/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.jboss.maven.plugins.qstools.checkers.AbstractBaseCheckerAdapter;
import org.jboss.maven.plugins.qstools.checkers.QSChecker;
import org.jboss.maven.plugins.qstools.checkers.Violation;
import org.jboss.maven.plugins.qstools.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component(role=QSChecker.class, hint="duplicatePropertiesChecker")
public class DuplicatePropertiesChecker
extends AbstractBaseCheckerAdapter {
    @Override
    public String getCheckerDescription() {
        return "Verifies if the POM has duplicate declared property";
    }

    @Override
    public void checkProject(MavenProject project, Document doc, Map<String, List<Violation>> results) throws Exception {
        NodeList properties = (NodeList)this.getxPath().evaluate("/project/properties/*", doc, XPathConstants.NODESET);
        HashSet<String> declaredProperties = new HashSet<String>();
        for (int x = 0; x < properties.getLength(); ++x) {
            Node property = properties.item(x);
            String propertyName = property.getNodeName();
            int lineNumber = XMLUtil.getLineNumberFromNode(property);
            if (declaredProperties.add(propertyName)) continue;
            String msg = "Property [%s] is declared more than once";
            this.addViolation(project.getFile(), results, lineNumber, String.format(msg, propertyName));
        }
    }
}

