/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.util.List;
import java.util.Map;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.jboss.maven.plugins.qstools.checkers.AbstractBaseCheckerAdapter;
import org.jboss.maven.plugins.qstools.checkers.QSChecker;
import org.jboss.maven.plugins.qstools.checkers.Violation;
import org.jboss.maven.plugins.qstools.common.PomOrderUtil;
import org.jboss.maven.plugins.qstools.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Component(role=QSChecker.class, hint="pomElementOrderChecker")
public class PomElementOrderChecker
extends AbstractBaseCheckerAdapter {
    @Requirement
    private PomOrderUtil pomOrderUtil;

    @Override
    public String getCheckerDescription() {
        return "Checks if POM xml elements are in specific order";
    }

    @Override
    public void checkProject(MavenProject project, Document doc, Map<String, List<Violation>> results) throws Exception {
        List<String> pomElementsOrder = this.getConfigurationProvider().getQuickstartsRules(project.getGroupId()).getPomOrder();
        Map<String, Node> elementsFound = this.pomOrderUtil.getElementsOrder(project, doc, pomElementsOrder);
        String previousElement = null;
        for (String element : elementsFound.keySet()) {
            int previousElementLineNumber;
            int lineNumber = XMLUtil.getLineNumberFromNode(elementsFound.get(element));
            if (previousElement != null && lineNumber < (previousElementLineNumber = XMLUtil.getLineNumberFromNode(elementsFound.get(previousElement)))) {
                String msg = "Element [%s] is not in the correct order: " + pomElementsOrder + ". It shoud come after [%s] on line %s";
                this.addViolation(project.getFile(), results, lineNumber, String.format(msg, element, previousElement, previousElementLineNumber));
            }
            previousElement = element;
        }
    }
}

