/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Proxy;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.jboss.maven.plugins.qstools.config.ConfigurationProvider;

@Component(role=Resources.class)
public class Resources {
    @Requirement
    private ConfigurationProvider configurationProvider;
    @Requirement
    private Context context;
    private MavenSession mavenSession;
    private Log log;

    private void configure() throws ContextException {
        this.log = (Log)this.context.get((Object)"qstools.log");
        this.mavenSession = (MavenSession)this.context.get((Object)"qstools.mavenSession");
    }

    public InputStream getFileInputStream(URL url) throws FileNotFoundException, ContextException {
        this.configure();
        InputStream repoStream = this.getCachedRepoStream(false, url);
        if (repoStream == null) {
            this.log.debug((CharSequence)("Local cache file " + this.getLocalCacheFile(url) + " doesn't exist or cache has been expired"));
            try {
                this.log.debug((CharSequence)("Retrieving File from Remote repository " + url));
                repoStream = this.retrieveFileFromRemoteRepository(url);
                this.setCachedRepoStream(repoStream, url);
                this.log.debug((CharSequence)("Forcing the use of local cache after download file without error from " + url));
                repoStream = this.getCachedRepoStream(true, url);
            }
            catch (Exception e) {
                this.log.warn((CharSequence)("It was not possible to contact the repository at " + url + " . Cause " + e.getMessage()));
                this.log.warn((CharSequence)"Falling back to cache!");
                repoStream = this.getCachedRepoStream(true, url);
            }
        }
        return repoStream;
    }

    private InputStream getCachedRepoStream(boolean force, URL url) throws FileNotFoundException {
        String logmessage = "Local file %1s %2s used! Reason: Force:[%3b] - LastModification: %4d/%5d";
        File localCacheFile = this.getLocalCacheFile(url);
        if (localCacheFile.exists()) {
            long cachedvalidity = 60000L;
            long lastModified = localCacheFile.lastModified();
            long timeSinceLastModification = System.currentTimeMillis() - lastModified;
            if (force || timeSinceLastModification <= cachedvalidity) {
                this.log.debug((CharSequence)String.format("Local file %1s %2s used! Reason: Force:[%3b] - LastModification: %4d/%5d", localCacheFile, "was", force, timeSinceLastModification, cachedvalidity));
                return new FileInputStream(localCacheFile);
            }
            this.log.debug((CharSequence)String.format("Local file %1s %2s used! Reason: Force:[%3b] - LastModification: %4d/%5d", localCacheFile, "was not", force, timeSinceLastModification, cachedvalidity));
        }
        return null;
    }

    private void setCachedRepoStream(InputStream stream, URL url) throws IOException {
        File localCacheFile = this.getLocalCacheFile(url);
        this.log.debug((CharSequence)("Content stored at " + localCacheFile));
        if (!localCacheFile.exists()) {
            localCacheFile.createNewFile();
        }
        FileOutputStream fos = new FileOutputStream(localCacheFile);
        int i = 0;
        while ((i = stream.read()) != -1) {
            fos.write(i);
        }
        fos.close();
    }

    private File getLocalCacheFile(URL url) {
        String repo = url.toString().replaceAll("[^a-zA-Z_0-9]", "");
        return new File(System.getProperty("java.io.tmpdir"), repo);
    }

    private InputStream retrieveFileFromRemoteRepository(URL url) throws Exception {
        if (url.getProtocol().startsWith("http")) {
            HttpGet httpGet = new HttpGet(url.toURI());
            DefaultHttpClient client = new DefaultHttpClient();
            this.configureProxy(client);
            HttpResponse httpResponse = client.execute((HttpUriRequest)httpGet);
            switch (httpResponse.getStatusLine().getStatusCode()) {
                case 200: {
                    this.log.debug((CharSequence)("Connected to repository! Getting " + url));
                    break;
                }
                case 404: {
                    this.log.error((CharSequence)("Failed! (File not found: " + url + ")"));
                    return null;
                }
                default: {
                    this.log.error((CharSequence)("Failed! (server returned status code: " + httpResponse.getStatusLine().getStatusCode()));
                    return null;
                }
            }
            this.log.info((CharSequence)("Downloading " + url));
            return httpResponse.getEntity().getContent();
        }
        if (url.getProtocol().startsWith("file")) {
            return new FileInputStream(new File(url.toURI()));
        }
        return null;
    }

    private void configureProxy(DefaultHttpClient client) {
        Proxy proxyConfig = null;
        if (this.mavenSession.getSettings().getProxies().size() > 0) {
            proxyConfig = (Proxy)this.mavenSession.getSettings().getProxies().get(0);
        }
        if (proxyConfig != null) {
            HttpHost proxy = new HttpHost(proxyConfig.getHost(), proxyConfig.getPort());
            client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            String proxyUsername = proxyConfig.getUsername();
            if (proxyUsername != null && !proxyUsername.isEmpty()) {
                String proxyPassword = proxyConfig.getPassword();
                AuthScope authScope = new AuthScope(proxyConfig.getHost(), proxyConfig.getPort());
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                client.getCredentialsProvider().setCredentials(authScope, (Credentials)credentials);
            }
        }
    }
}

