/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jboss.maven.plugins.qstools.checkers.QSChecker;
import org.jboss.maven.plugins.qstools.fixers.QSFixer;

public class Rules {
    private List<Object> configurations;

    public Rules(List<Object> configurations) {
        this.configurations = configurations;
    }

    public Map<String, String> getMavenApprovedRepositories() {
        List repositories = (List)this.getConfig("maven-approve-repositories");
        HashMap<String, String> p = new HashMap<String, String>();
        for (Object o : repositories) {
            p.putAll((Map)o);
        }
        return p;
    }

    public String getMavenRepositoryComment() {
        return (String)this.getConfig("maven-repositories-comment");
    }

    public boolean isCheckerIgnored(Class<? extends QSChecker> checker) {
        List ignoredCheckers = (List)this.getConfig("ignored-checkers");
        return ignoredCheckers.contains(checker.getSimpleName());
    }

    public List<String> getIgnoredUnusedProperties() {
        return (List)this.getConfig("ignored-unused-properties");
    }

    public List<String> getIgnoredDifferentValuesProperties() {
        return (List)this.getConfig("ignored-differet-value-properties");
    }

    public String getExcludes() {
        Object excludes = this.getConfig("excludes");
        return excludes.toString().replace('[', ' ').replace(']', ' ');
    }

    public List<String> getExcludesArray() {
        List excludes = (List)this.getConfig("excludes");
        return excludes;
    }

    public String getCheckerSpecificExcludes(QSChecker module) {
        Object moduleExclude = this.getConfig("excludes-" + module.getClass().getSimpleName());
        return moduleExclude == null ? "" : moduleExclude.toString().replace('[', ' ').replace(']', ' ');
    }

    public List<String> getFixerSpecificExcludesArray(QSFixer fixer) {
        List moduleExclude = (List)this.getConfig("excludes-" + fixer.getClass().getSimpleName());
        return moduleExclude == null ? new ArrayList() : moduleExclude;
    }

    public String getExpectedCompilerSource() {
        return (String)this.getConfig("expected-compiler-source");
    }

    public String getHeaderLocation() {
        return (String)this.getConfig("header-file");
    }

    public String getLicenseFileLocation() {
        return (String)this.getConfig("license-file");
    }

    public String getEclipseFormatterProfileLocation() {
        return (String)this.getConfig("eclipse-formatter-location");
    }

    public String getHeaderDefinitionLocation() {
        return (String)this.getConfig("header-definition");
    }

    public String getGroupId() {
        return (String)this.getConfig("groupid");
    }

    public String getArtifactIdPrefix() {
        return (String)this.getConfig("artifactid-prefix");
    }

    public String getPomNamePattern() {
        return (String)this.getConfig("pom-name-pattern");
    }

    public String getPomNamePatternForSubmodule() {
        return (String)this.getConfig("pom-name-pattern-submodule");
    }

    public Map<String, String> getFinalNamePatterns() {
        List packagingAsList = (List)this.getConfig("final-name-patterns");
        HashMap<String, String> p = new HashMap<String, String>();
        for (Object o : packagingAsList) {
            p.putAll((Map)o);
        }
        return p;
    }

    public Properties getExpectedBomVersion() {
        List propertiesAsList = (List)this.getConfig("expected-bom-versions");
        Properties p = new Properties();
        for (Object o : propertiesAsList) {
            p.putAll((Map<?, ?>)((Map)o));
        }
        return p;
    }

    public Properties getPropertiesNames() {
        List propertiesAsList = (List)this.getConfig("property-names");
        Properties p = new Properties();
        for (Object o : propertiesAsList) {
            p.putAll((Map<?, ?>)((Map)o));
        }
        return p;
    }

    public List<String> getPomOrder() {
        List pomOrder = (List)this.getConfig("pom-order");
        ArrayList<String> list = new ArrayList<String>();
        for (String o : pomOrder) {
            list.add(o);
        }
        return list;
    }

    public List<String> getIgnoredModules() {
        List modules = (List)this.getConfig("ignored-modules");
        ArrayList<String> list = new ArrayList<String>();
        for (String o : modules) {
            list.add(o);
        }
        return list;
    }

    public Map<String, String> getReadmeMetadatas() {
        List metadatas = (List)this.getConfig("readme-metadatas");
        HashMap<String, String> map = new HashMap<String, String>();
        for (Object o : metadatas) {
            map.putAll((Map)o);
        }
        return map;
    }

    public Properties getProjectBomsMigration() {
        List propertiesAsList = (List)this.getConfig("project-boms-migration");
        Properties p = new Properties();
        for (Object o : propertiesAsList) {
            p.putAll((Map<?, ?>)((Map)o));
        }
        return p;
    }

    public Object getConfig(String configValue) {
        Object value = null;
        for (Object config : this.configurations) {
            Object foundValue = ((Map)config).get(configValue);
            if (foundValue == null) continue;
            value = foundValue;
        }
        return value;
    }
}

