/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.fixers;

import javax.xml.xpath.XPathConstants;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.jboss.maven.plugins.qstools.fixers.AbstractBaseFixerAdapter;
import org.jboss.maven.plugins.qstools.fixers.QSFixer;
import org.jboss.maven.plugins.qstools.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Component(role=QSFixer.class, hint="FinalNameFixer")
public class FinalNameFixer
extends AbstractBaseFixerAdapter {
    @Override
    public String getFixerDescription() {
        return "Fix <finalName/> on all pom.xml files";
    }

    @Override
    public void fixProject(MavenProject project, Document doc) throws Exception {
        String declaredFinalName;
        String packaging = project.getPackaging();
        String expectedFinalName = this.getConfigurationProvider().getQuickstartsRules(project.getGroupId()).getFinalNamePatterns().get(packaging);
        Node finalNameNode = (Node)this.getxPath().evaluate("//finalName", doc, XPathConstants.NODE);
        String string = declaredFinalName = finalNameNode == null ? project.getBuild().getFinalName() : finalNameNode.getTextContent();
        if (expectedFinalName != null && !expectedFinalName.equals(declaredFinalName)) {
            Node buildNode = (Node)this.getxPath().evaluate("/project/build", doc, XPathConstants.NODE);
            if (buildNode == null) {
                buildNode = doc.createElement("build");
                Node projectNode = (Node)this.getxPath().evaluate("/project", doc, XPathConstants.NODE);
                projectNode.appendChild(doc.createTextNode("    "));
                projectNode.appendChild(buildNode);
            }
            if ((finalNameNode = (Node)this.getxPath().evaluate("/project/build/finalName", doc, XPathConstants.NODE)) == null) {
                finalNameNode = doc.createElement("finalName");
                buildNode.insertBefore(finalNameNode, buildNode.getFirstChild());
            }
            finalNameNode.setTextContent(expectedFinalName);
        }
        XMLUtil.writeXML(doc, project.getFile());
    }
}

