/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.fixers;

import javax.xml.xpath.XPathConstants;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.jboss.maven.plugins.qstools.fixers.AbstractBaseFixerAdapter;
import org.jboss.maven.plugins.qstools.fixers.QSFixer;
import org.jboss.maven.plugins.qstools.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Component(role=QSFixer.class, hint="LicenseFixer")
public class LicenseFixer
extends AbstractBaseFixerAdapter {
    @Override
    public String getFixerDescription() {
        return "Apply Apache V2 license to all pom.xml files";
    }

    @Override
    public void fixProject(MavenProject project, Document doc) throws Exception {
        Node licenseURL = (Node)this.getxPath().evaluate("/project/licenses/license/url", doc, XPathConstants.NODE);
        if (licenseURL == null || !licenseURL.getTextContent().contains("apache")) {
            Node licensesElement = (Node)this.getxPath().evaluate("/project/licenses", doc, XPathConstants.NODE);
            if (licensesElement == null) {
                licensesElement = doc.createElement("licenses");
                Element projectElement = (Element)this.getxPath().evaluate("/project", doc, XPathConstants.NODE);
                projectElement.appendChild(doc.createTextNode("\n\n    "));
                projectElement.appendChild(licensesElement);
            }
            Element license = doc.createElement("license");
            Element name = doc.createElement("name");
            name.setTextContent("Apache License, Version 2.0");
            Element distribution = doc.createElement("distribution");
            distribution.setTextContent("repo");
            Element url = doc.createElement("url");
            url.setTextContent("http://www.apache.org/licenses/LICENSE-2.0.html");
            license.appendChild(name);
            license.appendChild(distribution);
            license.appendChild(url);
            licensesElement.appendChild(doc.createTextNode("\n        "));
            licensesElement.appendChild(license);
        }
        XMLUtil.writeXML(doc, project.getFile());
    }
}

