/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.fixers;

import javax.xml.xpath.XPathConstants;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.jboss.maven.plugins.qstools.fixers.AbstractBaseFixerAdapter;
import org.jboss.maven.plugins.qstools.fixers.QSFixer;
import org.jboss.maven.plugins.qstools.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component(role=QSFixer.class, hint="MavenCompilerFixer")
public class MavenCompilerFixer
extends AbstractBaseFixerAdapter {
    @Override
    public String getFixerDescription() {
        return "Fix the maven.compiler.(source|target) from pom.xml files";
    }

    @Override
    public void fixProject(MavenProject project, Document doc) throws Exception {
        String compilerSource = this.getConfigurationProvider().getQuickstartsRules(project.getGroupId()).getExpectedCompilerSource();
        this.ensurePropertiesElementExists(doc);
        this.ensurePropertySet(doc, "maven.compiler.target", compilerSource);
        this.ensurePropertySet(doc, "maven.compiler.source", compilerSource);
        Node compilerNode = (Node)this.getxPath().evaluate("//plugin[artifactId='maven-compiler-plugin']", doc, XPathConstants.NODE);
        Node compilerConfigNode = (Node)this.getxPath().evaluate("//plugin[artifactId='maven-compiler-plugin']/./configuration", doc, XPathConstants.NODE);
        if (compilerNode != null && compilerConfigNode == null) {
            XMLUtil.removePreviousWhiteSpace(compilerNode);
            compilerNode.getParentNode().removeChild(compilerNode);
        } else if (compilerConfigNode != null) {
            this.removeConfigIfPresent(compilerConfigNode, "target");
            this.removeConfigIfPresent(compilerConfigNode, "source");
        }
        Node commentNode = null;
        if (compilerNode != null && compilerNode.getPreviousSibling() != null && compilerNode.getPreviousSibling() != null && compilerNode.getPreviousSibling().getPreviousSibling().getNodeType() == 8) {
            commentNode = compilerNode.getPreviousSibling().getPreviousSibling();
        }
        if (compilerConfigNode != null && !XMLUtil.hasChildElements(compilerConfigNode)) {
            if (commentNode != null) {
                XMLUtil.removePreviousWhiteSpace(commentNode);
                commentNode.getParentNode().removeChild(commentNode);
            }
            XMLUtil.removePreviousWhiteSpace(compilerNode);
            compilerNode.getParentNode().removeChild(compilerNode);
        }
        XMLUtil.writeXML(doc, project.getFile());
    }

    private void removeConfigIfPresent(Node compilerConfigNode, String configItem) throws Exception {
        NodeList configs = compilerConfigNode.getChildNodes();
        for (int i = 0; i < configs.getLength(); ++i) {
            Node config = configs.item(i);
            if (!config.getNodeName().equals(configItem)) continue;
            XMLUtil.removePreviousWhiteSpace(config);
            compilerConfigNode.removeChild(config);
        }
    }

    private void ensurePropertySet(Document doc, String key, String value) throws Exception {
        Element propertiesElement = (Element)this.getxPath().evaluate("/project/properties", doc, XPathConstants.NODE);
        Element property = (Element)this.getxPath().evaluate("/project/properties/" + key, doc, XPathConstants.NODE);
        if (property == null) {
            Element targetElement = doc.createElement(key);
            targetElement.setTextContent(value);
            propertiesElement.appendChild(doc.createTextNode("    "));
            propertiesElement.appendChild(targetElement);
            propertiesElement.appendChild(doc.createTextNode("\n    "));
        } else if (!property.getTextContent().equals(value)) {
            property.setTextContent(value);
        }
    }

    private void ensurePropertiesElementExists(Document doc) throws Exception {
        Element propertiesElement = (Element)this.getxPath().evaluate("/project/properties", doc, XPathConstants.NODE);
        if (propertiesElement == null) {
            propertiesElement = doc.createElement("properties");
            Node projectElement = (Node)this.getxPath().evaluate("/project", doc, XPathConstants.NODE);
            projectElement.appendChild(doc.createTextNode("\n\n    "));
            projectElement.appendChild(propertiesElement);
            propertiesElement.appendChild(doc.createTextNode("\n    "));
        }
    }
}

