/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.fixers;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.jboss.maven.plugins.qstools.common.PomOrderUtil;
import org.jboss.maven.plugins.qstools.fixers.AbstractBaseFixerAdapter;
import org.jboss.maven.plugins.qstools.fixers.QSFixer;
import org.jboss.maven.plugins.qstools.xml.PositionalXMLReader;
import org.jboss.maven.plugins.qstools.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Component(role=QSFixer.class, hint="PomElementOrderFixer")
public class PomElementOrderFixer
extends AbstractBaseFixerAdapter {
    @Requirement
    private PomOrderUtil pomOrderUtil;

    @Override
    public String getFixerDescription() {
        return "Fix the pom.xml element order";
    }

    @Override
    public void fixProject(MavenProject project, Document doc) throws Exception {
        Node elementNode;
        Node commentNode;
        List<String> pomElementsOrder = this.getConfigurationProvider().getQuickstartsRules(project.getGroupId()).getPomOrder();
        Map<String, Node> elementsFound = this.pomOrderUtil.getElementsOrder(project, doc, pomElementsOrder);
        ArrayList<String> elementsList = new ArrayList<String>(elementsFound.keySet());
        for (String element : elementsList) {
            commentNode = null;
            elementNode = (Node)this.getxPath().evaluate("/project/" + element, doc, XPathConstants.NODE);
            if (elementNode.getPreviousSibling() != null && elementNode.getPreviousSibling().getNodeType() == 8) {
                commentNode = elementNode.getPreviousSibling();
            }
            for (String anotherElement : elementsList) {
                if (elementsList.indexOf(element) >= elementsList.indexOf(anotherElement)) continue;
                Node anotherElementNode = (Node)this.getxPath().evaluate("/project/" + anotherElement, doc, XPathConstants.NODE);
                XMLUtil.removePreviousWhiteSpace(anotherElementNode);
                anotherElementNode.getParentNode().insertBefore(elementNode, anotherElementNode);
                if (commentNode == null) continue;
                XMLUtil.removePreviousWhiteSpace(commentNode);
                elementNode.getParentNode().insertBefore(commentNode, elementNode);
            }
        }
        XMLUtil.writeXML(doc, project.getFile());
        doc = PositionalXMLReader.readXML(new FileInputStream(project.getFile()));
        for (String element : elementsList) {
            commentNode = null;
            elementNode = (Node)this.getxPath().evaluate("/project/" + element, doc, XPathConstants.NODE);
            if (elementNode.getChildNodes().getLength() <= 1) continue;
            commentNode = null;
            if (elementNode.getPreviousSibling() != null && elementNode.getPreviousSibling().getPreviousSibling() != null && elementNode.getPreviousSibling().getPreviousSibling().getNodeType() == 8) {
                commentNode = elementNode.getPreviousSibling().getPreviousSibling();
                XMLUtil.removePreviousWhiteSpace(commentNode);
                elementNode.getParentNode().insertBefore(doc.createTextNode("\n\n    "), commentNode);
                continue;
            }
            XMLUtil.removePreviousWhiteSpace(elementNode);
            elementNode.getParentNode().insertBefore(doc.createTextNode("\n\n    "), elementNode);
        }
        XMLUtil.writeXML(doc, project.getFile());
    }

    @Override
    public int order() {
        return 10;
    }
}

