/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.jboss.maven.plugins.qstools.checkers.AbstractBaseCheckerAdapter;
import org.jboss.maven.plugins.qstools.checkers.QSChecker;
import org.jboss.maven.plugins.qstools.checkers.Violation;
import org.jboss.maven.plugins.qstools.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Component(role=QSChecker.class, hint="finalNameChecker")
public class FinalNameChecker
extends AbstractBaseCheckerAdapter {
    @Override
    public String getCheckerDescription() {
        return "Checks if ths <finalName/> element follow the expected patter";
    }

    @Override
    public void checkProject(MavenProject project, Document doc, Map<String, List<Violation>> results) throws Exception {
        String declaredFinalName;
        String packaging = project.getPackaging();
        String expectedFinalName = this.getConfigurationProvider().getQuickstartsRules(project.getGroupId()).getFinalNamePatterns().get(packaging);
        Node finalNameNode = (Node)this.getxPath().evaluate("//finalName", doc, XPathConstants.NODE);
        String string = declaredFinalName = finalNameNode == null ? project.getBuild().getFinalName() : finalNameNode.getTextContent();
        if (expectedFinalName != null && !expectedFinalName.equals(declaredFinalName)) {
            int lineNumber = finalNameNode == null ? 0 : XMLUtil.getLineNumberFromNode(finalNameNode);
            this.addViolation(project.getFile(), results, lineNumber, "File doesn't contain <finalName>" + expectedFinalName + "</finalName>");
        }
    }
}

