/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.io.FileUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.jboss.maven.plugins.qstools.QSToolsException;
import org.jboss.maven.plugins.qstools.checkers.QSChecker;
import org.jboss.maven.plugins.qstools.checkers.Violation;
import org.jboss.maven.plugins.qstools.config.ConfigurationProvider;
import org.mozilla.universalchardet.UniversalDetector;

@Component(role=QSChecker.class, hint="JavaEncondingChecker")
public class JavaEncondingChecker
implements QSChecker {
    private int violationsQtd;
    private UniversalDetector encodingDetector = new UniversalDetector(null);
    @Requirement
    private ConfigurationProvider configurationProvider;
    private String checkerMessage;

    @Override
    public String getCheckerDescription() {
        return "Verifies if java source character encoding is UTF-8";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<Violation>> check(MavenProject project, MavenSession mavenSession, List<MavenProject> reactorProjects, Log log) throws QSToolsException {
        TreeMap<String, List<Violation>> results;
        block11: {
            results = new TreeMap<String, List<Violation>>();
            try {
                if (this.configurationProvider.getQuickstartsRules(project.getGroupId()).isCheckerIgnored(this.getClass())) {
                    this.checkerMessage = "This checker is ignored for this groupId in config file.";
                    break block11;
                }
                List sourceFiles = FileUtils.getFiles((File)project.getBasedir(), (String)"**/*.java", (String)"");
                for (File source : sourceFiles) {
                    FileInputStream fis = null;
                    try {
                        int nread;
                        fis = new FileInputStream(source);
                        byte[] buf = new byte[4096];
                        while ((nread = fis.read(buf)) > 0 && !this.encodingDetector.isDone()) {
                            this.encodingDetector.handleData(buf, 0, nread);
                        }
                        this.encodingDetector.dataEnd();
                        String encoding = this.encodingDetector.getDetectedCharset();
                        if (encoding == null || encoding.equalsIgnoreCase("UTF-8")) continue;
                        String rootDirectory = (mavenSession.getExecutionRootDirectory() + File.separator).replace("\\", "\\\\");
                        String fileAsString = source.getAbsolutePath().replace(rootDirectory, "");
                        if (results.get(fileAsString) == null) {
                            results.put(fileAsString, new ArrayList());
                        }
                        ((List)results.get(fileAsString)).add(new Violation(this.getClass(), 0, "This file contains a non UTF-8 characters. It was detected as " + encoding));
                        ++this.violationsQtd;
                    }
                    finally {
                        this.encodingDetector.reset();
                        if (fis == null) continue;
                        fis.close();
                    }
                }
                if (this.getCheckerMessage() != null) {
                    log.info((CharSequence)("--> Checker Message: " + this.getCheckerMessage()));
                }
                if (this.violationsQtd > 0) {
                    log.info((CharSequence)("There are " + this.violationsQtd + " checkers violations"));
                }
            }
            catch (Exception e) {
                throw new QSToolsException(e);
            }
        }
        return results;
    }

    @Override
    public int getViolatonsQtd() {
        return this.violationsQtd;
    }

    @Override
    public void resetViolationsQtd() {
        this.violationsQtd = 0;
    }

    @Override
    public String getCheckerMessage() {
        return this.checkerMessage;
    }
}

