/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.jboss.maven.plugins.qstools.common.ProjectUtil;
import org.jboss.maven.plugins.qstools.config.Rules;

@Component(role=PomNameUtil.class)
public class PomNameUtil {
    @Requirement
    private ProjectUtil projectUtil;

    public String getExpectedPattern(MavenProject project, Rules rules) throws IOException {
        String pattern;
        String pomNamePattern = rules.getPomNamePattern();
        String pomNamePatternSubmodule = rules.getPomNamePatternForSubmodule();
        String folderName = project.getBasedir().getName();
        String parentFolder = project.getBasedir().getParentFile().getName();
        if (this.projectUtil.isSubProjec(project)) {
            File parentReadme = new File(project.getBasedir().getParent(), "README.md");
            String targetProject = this.getTargetProduct(parentReadme);
            pattern = pomNamePatternSubmodule.replace("<target-product>", targetProject).replace("<project-folder>", parentFolder).replace("<submodule-folder>", folderName);
        } else {
            File readme = new File(project.getBasedir(), "README.md");
            if (readme.exists()) {
                String targetProject = this.getTargetProduct(readme);
                pattern = pomNamePattern.replace("<target-product>", targetProject).replace("<project-folder>", folderName);
            } else {
                pattern = project.getName();
            }
        }
        return pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTargetProduct(File readme) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(readme));
        try {
            while (br.ready()) {
                String line = br.readLine();
                if (!line.startsWith("Target Product:")) continue;
                String string = line.substring("Target Product:".length(), line.length()).trim();
                return string;
            }
            String string = "";
            return string;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }
}

