/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.fixers;

import java.io.FileInputStream;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.jboss.maven.plugins.qstools.QSToolsException;
import org.jboss.maven.plugins.qstools.common.ArtifactIdNameUtil;
import org.jboss.maven.plugins.qstools.config.ConfigurationProvider;
import org.jboss.maven.plugins.qstools.config.Rules;
import org.jboss.maven.plugins.qstools.fixers.QSFixer;
import org.jboss.maven.plugins.qstools.xml.PositionalXMLReader;
import org.jboss.maven.plugins.qstools.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component(role=QSFixer.class, hint="ArtifactIdPrefixFixer")
public class ArtifactIdNameFixer
implements QSFixer {
    protected XPath xPath = XPathFactory.newInstance().newXPath();
    @Requirement
    private ConfigurationProvider configurationProvider;
    @Requirement
    private ArtifactIdNameUtil artifactIdNameUtil;

    @Override
    public String getFixerDescription() {
        return "Fix the <artifactId/> to match the folder name on pom.xml files";
    }

    @Override
    public void fix(MavenProject project, MavenSession mavenSession, List<MavenProject> reactorProjects, Log log) throws QSToolsException {
        try {
            Document doc;
            Rules rules = this.configurationProvider.getQuickstartsRules(project.getGroupId());
            List<ArtifactIdNameUtil.PomInformation> pomsWithInvalidArtifactIds = this.artifactIdNameUtil.findAllIncorrectArtifactIdNames(reactorProjects, rules);
            for (ArtifactIdNameUtil.PomInformation pi : pomsWithInvalidArtifactIds) {
                doc = PositionalXMLReader.readXML(new FileInputStream(pi.getProject().getFile()));
                Node artifactIdNode = (Node)this.xPath.evaluate("/project/artifactId", doc, XPathConstants.NODE);
                artifactIdNode.setTextContent(pi.getExpectedArtifactId());
                XMLUtil.writeXML(doc, pi.getProject().getFile());
            }
            for (MavenProject subProject : reactorProjects) {
                doc = PositionalXMLReader.readXML(new FileInputStream(subProject.getFile()));
                Node parentArtifactIdNode = (Node)this.xPath.evaluate("/project/parent/artifactId", doc, XPathConstants.NODE);
                if (parentArtifactIdNode != null && subProject.getParentFile() != null) {
                    Document parentDoc = PositionalXMLReader.readXML(new FileInputStream(subProject.getParentFile()));
                    Node artifactIdNode = (Node)this.xPath.evaluate("/project/artifactId", parentDoc, XPathConstants.NODE);
                    if (!parentArtifactIdNode.getTextContent().equals(artifactIdNode.getTextContent())) {
                        parentArtifactIdNode.setTextContent(artifactIdNode.getTextContent());
                    }
                }
                for (ArtifactIdNameUtil.PomInformation pi : pomsWithInvalidArtifactIds) {
                    NodeList artfactIdNodes = (NodeList)this.xPath.evaluate("//artifactId[text()='" + pi.getActualArtifactId() + "']", doc, XPathConstants.NODESET);
                    for (int x = 0; x < artfactIdNodes.getLength(); ++x) {
                        Node artfactIdNode = artfactIdNodes.item(x);
                        if (artfactIdNode == null) continue;
                        artfactIdNode.setTextContent(pi.getExpectedArtifactId());
                    }
                }
                XMLUtil.writeXML(doc, subProject.getFile());
            }
        }
        catch (Exception e) {
            throw new QSToolsException(e);
        }
    }

    @Override
    public int order() {
        return 0;
    }
}

