/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.fixers;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jboss.maven.plugins.qstools.QSToolsException;
import org.jboss.maven.plugins.qstools.config.ConfigurationProvider;
import org.jboss.maven.plugins.qstools.config.Rules;
import org.jboss.maven.plugins.qstools.fixers.QSFixer;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Component(role=QSFixer.class, hint="FileHeaderFixer")
public class FileHeaderFixer
implements QSFixer {
    private BuildPluginManager pluginManager;
    @Requirement
    private Context context;
    @Requirement
    private ConfigurationProvider configurationProvider;

    @Override
    public String getFixerDescription() {
        return "Fix the license header on all files";
    }

    @Override
    public void fix(MavenProject project, MavenSession mavenSession, List<MavenProject> reactorProjects, Log log) throws QSToolsException {
        Rules rules = this.configurationProvider.getQuickstartsRules(project.getGroupId());
        try {
            String[] includesExtensions;
            ArrayList<MojoExecutor.Element> excludes = new ArrayList<MojoExecutor.Element>();
            for (String exclude : rules.getExcludesArray()) {
                excludes.add(MojoExecutor.element((String)"exclude", (String)exclude));
            }
            for (String exclude : rules.getFixerSpecificExcludesArray(this)) {
                excludes.add(MojoExecutor.element((String)"exclude", (String)exclude));
            }
            ArrayList<MojoExecutor.Element> includes = new ArrayList<MojoExecutor.Element>();
            for (String include : includesExtensions = new String[]{"**/*.xml", "**/*.xsd", "**/*.java", "**/*.js", "**/*.properties", "**/*.html", "**/*.xhtml", "**/*.sql", "**/*.css"}) {
                includes.add(MojoExecutor.element((String)"include", (String)include));
            }
            this.pluginManager = (BuildPluginManager)this.context.get((Object)"qstools.plugin_manager");
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"com.mycila"), (String)MojoExecutor.artifactId((String)"license-maven-plugin"), (String)MojoExecutor.version((String)"2.5")), (String)MojoExecutor.goal((String)"format"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"header"), (String)rules.getLicenseFileLocation()), MojoExecutor.element((String)MojoExecutor.name((String)"aggregate"), (String)"true"), MojoExecutor.element((String)MojoExecutor.name((String)"strictCheck"), (String)"true"), MojoExecutor.element((String)MojoExecutor.name((String)"encoding"), (String)"utf-8"), MojoExecutor.element((String)MojoExecutor.name((String)"headerDefinitions"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"headerDefinition"), (String)rules.getHeaderDefinitionLocation())}), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])includes.toArray(new MojoExecutor.Element[0])), MojoExecutor.element((String)MojoExecutor.name((String)"excludes"), (MojoExecutor.Element[])excludes.toArray(new MojoExecutor.Element[0]))}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)project, (MavenSession)mavenSession, (BuildPluginManager)this.pluginManager));
        }
        catch (Exception e) {
            throw new QSToolsException(e);
        }
    }

    @Override
    public int order() {
        return 0;
    }
}

