/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.fixers;

import javax.xml.xpath.XPathConstants;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.jboss.maven.plugins.qstools.common.PomNameUtil;
import org.jboss.maven.plugins.qstools.config.Rules;
import org.jboss.maven.plugins.qstools.fixers.AbstractBaseFixerAdapter;
import org.jboss.maven.plugins.qstools.fixers.QSFixer;
import org.jboss.maven.plugins.qstools.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Component(role=QSFixer.class, hint="PomNameFixer")
public class PomNameFixer
extends AbstractBaseFixerAdapter {
    @Requirement
    private PomNameUtil pomNameUtil;

    @Override
    public String getFixerDescription() {
        return "Replace the <name/> on pom.xml with the expected pattern";
    }

    @Override
    public void fixProject(MavenProject project, Document doc) throws Exception {
        Rules rules = this.getConfigurationProvider().getQuickstartsRules(project.getGroupId());
        String pattern = this.pomNameUtil.getExpectedPattern(project, rules);
        if (!pattern.equals(project.getName())) {
            Node nameNode = (Node)this.getxPath().evaluate("/project/name", doc, XPathConstants.NODE);
            if (nameNode == null) {
                nameNode = doc.createElement("name");
                Node projectNode = (Node)this.getxPath().evaluate("/project", doc, XPathConstants.NODE);
                projectNode.appendChild(doc.createTextNode("    "));
                projectNode.appendChild(nameNode);
            }
            nameNode.setTextContent(pattern);
            XMLUtil.writeXML(doc, project.getFile());
        }
    }
}

