/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.fixers;

import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.jboss.maven.plugins.qstools.common.ReadmeUtil;
import org.jboss.maven.plugins.qstools.fixers.AbstractBaseFixerAdapter;
import org.jboss.maven.plugins.qstools.fixers.QSFixer;
import org.w3c.dom.Document;

@Component(role=QSFixer.class, hint="ReadmeMetadataFixer")
public class ReadmeMetadataFixer
extends AbstractBaseFixerAdapter {
    @Requirement
    private ReadmeUtil readmeUtil;
    private String regexPattern;

    @Override
    public String getFixerDescription() {
        return "Adds two empty spaces at the end of Readme Metadatas";
    }

    @Override
    public void fixProject(MavenProject project, Document doc) throws Exception {
        File readme = new File(project.getBasedir(), "README.md");
        this.regexPattern = this.readmeUtil.setupRegexPattern(project.getGroupId(), null);
        if (readme.exists()) {
            this.fixReadmeFile(project.getGroupId(), readme);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixReadmeFile(String groupId, File readme) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(readme));
        try {
            Pattern p = Pattern.compile(this.regexPattern);
            StringBuilder sb = new StringBuilder();
            boolean readmeModified = false;
            while (br.ready()) {
                String line = br.readLine();
                Matcher m = p.matcher(line);
                if (m.find() && !line.matches("\\w.*\\s\\s")) {
                    line = line.replace(line.trim(), line + "  ");
                    readmeModified = true;
                }
                sb.append(line + "\n");
            }
            if (readmeModified) {
                Files.write((CharSequence)sb.toString(), (File)readme, (Charset)Charset.forName("UTF-8"));
                this.getLog().info((CharSequence)("Saving changes to " + readme));
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }
}

