/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.maven;

import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.interpolation.PrefixedValueSourceWrapper;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.jboss.maven.plugins.qstools.maven.MavenDependency;
import org.w3c.dom.Node;

@Component(role=DependencyProvider.class)
public class DependencyProvider {
    public MavenDependency getDependencyFromNode(MavenProject project, Node dependency) throws InterpolationException {
        String groupId = null;
        String artifactId = null;
        String declaredVersion = null;
        String interpoledVersion = null;
        String type = null;
        String scope = null;
        for (int x = 0; x < dependency.getChildNodes().getLength(); ++x) {
            Node node = dependency.getChildNodes().item(x);
            if ("groupId".equals(node.getNodeName())) {
                groupId = node.getTextContent();
            }
            if ("artifactId".equals(node.getNodeName())) {
                artifactId = node.getTextContent();
            }
            if ("version".equals(node.getNodeName())) {
                declaredVersion = node.getTextContent();
                interpoledVersion = this.resolveMavenProperty(project, declaredVersion);
            }
            if ("type".equals(node.getNodeName())) {
                type = node.getTextContent();
            }
            if (!"scope".equals(node.getNodeName())) continue;
            scope = node.getTextContent();
        }
        return new MavenDependency(groupId, artifactId, declaredVersion, interpoledVersion, type, scope);
    }

    private String resolveMavenProperty(MavenProject project, String textContent) throws InterpolationException {
        StringSearchInterpolator interpolator = new StringSearchInterpolator();
        PrefixedValueSourceWrapper modelWrapper = new PrefixedValueSourceWrapper((ValueSource)new ObjectBasedValueSource((Object)project.getModel()), "project.", true);
        interpolator.addValueSource((ValueSource)modelWrapper);
        interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(project.getModel().getProperties()));
        return interpolator.interpolate(textContent);
    }
}

