/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools;

import edu.emory.mathcs.backport.java.util.TreeSet;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.StringUtils;
import org.codehaus.plexus.PlexusContainer;
import org.jboss.maven.plugins.qstools.Utils;
import org.jboss.maven.plugins.qstools.fixers.QSFixer;

@Mojo(name="fix", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.COMPILE, requiresProject=true, threadSafe=true, aggregator=true)
public class QSFixViolationsMojo
extends AbstractMojo {
    @Component
    private PlexusContainer container;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Component
    private BuildPluginManager pluginManager;
    @Parameter(property="qstools.configFileURL", defaultValue="https://raw.github.com/jboss-developer/maven-qstools-plugin/master/config/qstools_config.yaml")
    private URL configFileURL;
    @Parameter(property="reactorProjects", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    private Comparator<QSFixer> fixerComparator = new Comparator<QSFixer>(){

        @Override
        public int compare(QSFixer o1, QSFixer o2) {
            int value = Integer.valueOf(o1.order()).compareTo(o2.order());
            if (value == 0) {
                return o1.getClass().getSimpleName().compareTo(o2.getClass().getSimpleName());
            }
            return value;
        }
    };

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.configurePlugin();
            this.getLog().warn((CharSequence)"Running this plugin CAN MODIFY your files. Make sure to have your changes commited before running this plugin");
            this.getLog().warn((CharSequence)"Do you want to continue[yes/NO]");
            String answer = System.console().readLine();
            if (answer.equalsIgnoreCase("yes")) {
                List fixersFound = this.container.lookupList(QSFixer.class);
                ArrayList fixers = new ArrayList(fixersFound);
                Collections.sort(fixers, this.fixerComparator);
                TreeSet fixerSelected = new TreeSet(this.fixerComparator);
                while (!answer.matches("(Q|q)|(R|r)")) {
                    this.getLog().warn((CharSequence)"Please select the Fixers you want to run. Selected Fixers are denoted by a leading '*'.");
                    int x = 0;
                    StringBuilder sb = new StringBuilder("\n");
                    for (QSFixer fixer : fixers) {
                        String part1 = "  " + (fixerSelected.contains(fixer) ? "* " : "  ") + ++x + " - " + fixer.getClass().getSimpleName();
                        String part1padded = StringUtils.rightPad((String)part1, (int)30);
                        String part2 = " - " + fixer.getFixerDescription() + "\n";
                        sb.append(part1padded + part2);
                    }
                    sb.append("    A - Select All             - Add all Fixers to the list to be run\n");
                    sb.append("    N - Select None            - Remove all currently selected Fixers from the list to be run\n");
                    sb.append("\n");
                    sb.append("    R - Run the plugin using the selected list of fixers (denoted by an *)\n");
                    sb.append("    Q - Quit without running any fixers\n");
                    sb.append("\n");
                    sb.append("Enter the number of the Fixer to select/deselect it. Enter 'A' to select all. Enter 'N' to deselect all. ");
                    sb.append("\n\nWhen ready, enter 'R' to run the selected list of Fixers or 'Q' to quit.");
                    this.getLog().info((CharSequence)sb);
                    answer = System.console().readLine();
                    if (answer.matches("[1-9][0-9]*")) {
                        QSFixer selectedFixer = (QSFixer)fixers.get(Integer.parseInt(answer) - 1);
                        if (fixerSelected.contains(selectedFixer)) {
                            fixerSelected.remove(selectedFixer);
                            continue;
                        }
                        fixerSelected.add(selectedFixer);
                        continue;
                    }
                    if (answer.equalsIgnoreCase("A")) {
                        fixerSelected.addAll(fixersFound);
                        continue;
                    }
                    if (!answer.equalsIgnoreCase("N")) continue;
                    fixerSelected.clear();
                }
                if (answer.equalsIgnoreCase("R")) {
                    for (QSFixer fixer : fixerSelected) {
                        this.getLog().info((CharSequence)("Running Fixer: " + fixer.getClass().getSimpleName()));
                        fixer.fix(this.mavenProject, this.mavenSession, this.reactorProjects, this.getLog());
                    }
                    this.getLog().info((CharSequence)(" ***** All projects were processed! Total Processed: " + this.reactorProjects.size() + "\nRun [mvn clean compile] to get sure that everything is working" + "\nRun [git diff] to see the changes made." + "\n"));
                }
            } else {
                this.getLog().info((CharSequence)"Aborted");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void configurePlugin() {
        this.getLog().info((CharSequence)("Using the following QSTools config file: " + this.configFileURL));
        this.container.getContext().put((Object)"qstools.configFileURL", (Object)this.configFileURL);
        this.container.getContext().put((Object)"qstools.log", (Object)this.getLog());
        this.container.getContext().put((Object)"qstools.mavenSession", (Object)this.mavenSession);
        this.container.getContext().put((Object)"qstools.ignored.quickstarts", Utils.readIgnoredFile());
        this.container.getContext().put((Object)"qstools.plugin_manager", (Object)this.pluginManager);
    }
}

