/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.jboss.maven.plugins.qstools.QSToolsException;
import org.jboss.maven.plugins.qstools.checkers.QSChecker;
import org.jboss.maven.plugins.qstools.checkers.Violation;
import org.jboss.maven.plugins.qstools.common.ArtifactIdNameUtil;
import org.jboss.maven.plugins.qstools.config.ConfigurationProvider;
import org.jboss.maven.plugins.qstools.config.Rules;

@Component(role=QSChecker.class, hint="artifactIdNameChecker")
public class ArtifactIdNameChecker
implements QSChecker {
    private int violationsQtd;
    @Requirement
    private ConfigurationProvider configurationProvider;
    @Requirement
    private ArtifactIdNameUtil artifactIdNameUtil;
    private String checkerMessage;

    @Override
    public int getViolatonsQtd() {
        return this.violationsQtd;
    }

    @Override
    public void resetViolationsQtd() {
        this.violationsQtd = 0;
    }

    @Override
    public String getCheckerDescription() {
        return "Check if the Maven ArtifactId uses a valid name";
    }

    @Override
    public Map<String, List<Violation>> check(MavenProject project, MavenSession mavenSession, List<MavenProject> reactorProjects, Log log) throws QSToolsException {
        TreeMap<String, List<Violation>> results = new TreeMap<String, List<Violation>>();
        try {
            if (this.configurationProvider.getQuickstartsRules(project.getGroupId()).isCheckerIgnored(this.getClass())) {
                this.checkerMessage = "This checker is ignored for this groupId in config file.";
            } else {
                Rules rules = this.configurationProvider.getQuickstartsRules(project.getGroupId());
                List<ArtifactIdNameUtil.PomInformation> pomsWithInvalidArtifactIds = this.artifactIdNameUtil.findAllIncorrectArtifactIdNames(reactorProjects, rules);
                for (ArtifactIdNameUtil.PomInformation pi : pomsWithInvalidArtifactIds) {
                    String rootDirectory = (mavenSession.getExecutionRootDirectory() + File.separator).replace("\\", "\\\\");
                    String fileAsString = pi.getProject().getFile().getAbsolutePath().replace(rootDirectory, "");
                    if (results.get(fileAsString) == null) {
                        results.put(fileAsString, new ArrayList());
                    }
                    String msg = "Project with the following artifactId [%s] doesn't match the required format. It should be: [%s]";
                    ((List)results.get(fileAsString)).add(new Violation(this.getClass(), pi.getLine(), String.format(msg, pi.getActualArtifactId(), pi.getExpectedArtifactId())));
                    ++this.violationsQtd;
                }
                if (this.getCheckerMessage() != null) {
                    log.info((CharSequence)("--> Checker Message: " + this.getCheckerMessage()));
                }
                if (this.violationsQtd > 0) {
                    log.info((CharSequence)("There are " + this.violationsQtd + " checkers violations"));
                }
            }
            return results;
        }
        catch (Exception e) {
            throw new QSToolsException(e);
        }
    }

    @Override
    public String getCheckerMessage() {
        return this.checkerMessage;
    }
}

