/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPathConstants;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.jboss.maven.plugins.qstools.Utils;
import org.jboss.maven.plugins.qstools.checkers.AbstractBaseCheckerAdapter;
import org.jboss.maven.plugins.qstools.checkers.MavenCentralRepositoryChecker;
import org.jboss.maven.plugins.qstools.checkers.QSChecker;
import org.jboss.maven.plugins.qstools.checkers.Violation;
import org.jboss.maven.plugins.qstools.common.ProjectUtil;
import org.jboss.maven.plugins.qstools.config.Rules;
import org.jboss.maven.plugins.qstools.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component(role=QSChecker.class, hint="MavenApprovedRepositoriesChecker")
public class MavenApprovedRepositoriesChecker
extends AbstractBaseCheckerAdapter {
    @Requirement
    private ProjectUtil projectUtil;

    @Override
    public String getCheckerDescription() {
        return "Check if Quickstart contains JBoss Maven approved repositories";
    }

    @Override
    public void checkProject(MavenProject project, Document doc, Map<String, List<Violation>> results) throws Exception {
        Rules rules = this.getConfigurationProvider().getQuickstartsRules(project.getGroupId());
        if (!rules.isCheckerIgnored(MavenCentralRepositoryChecker.class)) {
            this.setCheckerMessage("This checker was ignored because MavenCentralRepositoryChecker is active.");
        } else {
            Node repositoriesNode = (Node)this.getxPath().evaluate("/project/repositories", doc, XPathConstants.NODE);
            if (!this.projectUtil.isSubProjec(project)) {
                String complement = "- Please, run mvn org.jboss.maven.plugins:qstools:" + Utils.getQStoolsVersion() + ":repositories to fix it";
                if (repositoriesNode == null) {
                    this.addViolation(project.getFile(), results, 0, "pom.xml doesn't contain a <repository /> section.");
                } else {
                    NodeList ids = (NodeList)this.getxPath().evaluate("/project/repositories/repository/id", doc, XPathConstants.NODESET);
                    Set<String> approvedIds = rules.getMavenApprovedRepositories().keySet();
                    for (int x = 0; x < ids.getLength(); ++x) {
                        String id = ids.item(x).getTextContent();
                        if (approvedIds.contains(id)) continue;
                        int lineNumber = XMLUtil.getLineNumberFromNode(ids.item(x));
                        this.addViolation(project.getFile(), results, lineNumber, "The following id [" + id + "] is not an approved JBoss Maven Repository Id." + complement);
                    }
                    NodeList urls = (NodeList)this.getxPath().evaluate("/project/repositories/repository/url", doc, XPathConstants.NODESET);
                    Collection<String> approvedUrlsRaw = rules.getMavenApprovedRepositories().values();
                    HashSet<String> approvedUrls = new HashSet<String>();
                    for (String rawValue : approvedUrlsRaw) {
                        approvedUrls.add(rawValue.split("[|]")[0]);
                    }
                    for (int x = 0; x < ids.getLength(); ++x) {
                        String url = urls.item(x).getTextContent();
                        if (approvedUrls.contains(url)) continue;
                        int lineNumber = XMLUtil.getLineNumberFromNode(urls.item(x));
                        this.addViolation(project.getFile(), results, lineNumber, "The following url [" + url + "] is not an approved JBoss Maven Repository URL." + complement);
                    }
                }
            }
        }
    }
}

