/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.jboss.maven.plugins.qstools.checkers.AbstractBaseCheckerAdapter;
import org.jboss.maven.plugins.qstools.checkers.QSChecker;
import org.jboss.maven.plugins.qstools.checkers.Violation;
import org.jboss.maven.plugins.qstools.common.PomNameUtil;
import org.jboss.maven.plugins.qstools.config.Rules;
import org.jboss.maven.plugins.qstools.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Component(role=QSChecker.class, hint="pomNameChecker")
public class PomNameChecker
extends AbstractBaseCheckerAdapter {
    @Requirement
    private PomNameUtil pomNameUtil;

    @Override
    public String getCheckerDescription() {
        return "Check if the POM.xml <name> uses the defined pattern";
    }

    @Override
    public void checkProject(MavenProject project, Document doc, Map<String, List<Violation>> results) throws Exception {
        Rules rules = this.getConfigurationProvider().getQuickstartsRules(project.getGroupId());
        String pattern = this.pomNameUtil.getExpectedPattern(project, rules);
        if (!pattern.equals(project.getName())) {
            Node nameNode = (Node)this.getxPath().evaluate("/project/name", doc, XPathConstants.NODE);
            int lineNumber = XMLUtil.getLineNumberFromNode(nameNode);
            String msg = "Project uses name [%s] but should use the define name: %s";
            this.addViolation(project.getFile(), results, lineNumber, String.format(msg, project.getName(), pattern));
        }
    }
}

