/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.jboss.maven.plugins.qstools.checkers.AbstractBaseCheckerAdapter;
import org.jboss.maven.plugins.qstools.checkers.QSChecker;
import org.jboss.maven.plugins.qstools.checkers.Violation;
import org.jboss.maven.plugins.qstools.common.ReadmeUtil;
import org.w3c.dom.Document;

@Component(role=QSChecker.class, hint="readmeChecker")
public class ReadmeChecker
extends AbstractBaseCheckerAdapter {
    @Requirement
    private ReadmeUtil readmeUtil;
    private String regexPattern;
    private String folderName;

    @Override
    public String getCheckerDescription() {
        return "Checks if README.md metadata is defined and if the title matches the folder name";
    }

    @Override
    public void checkProject(MavenProject project, Document doc, Map<String, List<Violation>> results) throws Exception {
        this.folderName = project.getBasedir().getName() + ":";
        this.regexPattern = this.readmeUtil.setupRegexPattern(project.getGroupId(), this.folderName);
        File readme = new File(project.getBasedir(), "README.md");
        if (readme.exists()) {
            this.checkReadmeFile(project.getGroupId(), readme, results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReadmeFile(String groupId, File readme, Map<String, List<Violation>> results) throws IOException {
        Map<String, String> metadatas = this.getConfigurationProvider().getQuickstartsRules(groupId).getReadmeMetadatas();
        BufferedReader br = new BufferedReader(new FileReader(readme));
        try {
            Pattern p = Pattern.compile(this.regexPattern);
            ArrayList<String> usedPatterns = new ArrayList<String>();
            HashMap<String, String> usedValues = new HashMap<String, String>();
            while (br.ready()) {
                String line = br.readLine();
                Matcher m = p.matcher(line);
                if (!m.find()) continue;
                usedPatterns.add(m.group());
                usedValues.put(m.group(), StringUtils.stripStart((String)line.substring(m.group().length(), line.length()), (String)" "));
            }
            for (String metadataRaw : metadatas.keySet()) {
                String metadata = metadataRaw.replace("FOLDER-NAME", this.folderName);
                if (usedPatterns.contains(metadata)) {
                    String expected;
                    String value = (String)usedValues.get(metadata);
                    if (value.matches(expected = metadatas.get(metadataRaw))) continue;
                    String msg = "Content for metadata [%s = %s] should follow the [%s] pattern";
                    this.addViolation(readme, results, 0, String.format(msg, metadata, value, expected));
                    continue;
                }
                String msg = "File doesn't contain [%s] metadata";
                this.addViolation(readme, results, 3, String.format(msg, metadata));
            }
            if (!usedPatterns.contains(this.folderName)) {
                String msg = "Readme title doesn't match the folder name: " + this.folderName;
                this.addViolation(readme, results, 1, msg);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }
}

