/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.io.FileInputStream;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.jboss.maven.plugins.qstools.QSToolsException;
import org.jboss.maven.plugins.qstools.checkers.AbstractBaseCheckerAdapter;
import org.jboss.maven.plugins.qstools.checkers.QSChecker;
import org.jboss.maven.plugins.qstools.checkers.Violation;
import org.jboss.maven.plugins.qstools.xml.PositionalXMLReader;
import org.jboss.maven.plugins.qstools.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Component(role=QSChecker.class, hint="SameVersionChecker")
public class SameVersionChecker
extends AbstractBaseCheckerAdapter {
    private String rootVersion;

    @Override
    public Map<String, List<Violation>> check(MavenProject project, MavenSession mavenSession, List<MavenProject> reactorProjects, Log log) throws QSToolsException {
        try {
            Document doc = PositionalXMLReader.readXML(new FileInputStream(project.getFile()));
            Node versionNode = (Node)this.getxPath().evaluate("/project/version", doc, XPathConstants.NODE);
            this.rootVersion = versionNode == null ? project.getVersion() : versionNode.getTextContent();
        }
        catch (Exception e) {
            throw new QSToolsException(e);
        }
        return super.check(project, mavenSession, reactorProjects, log);
    }

    @Override
    public String getCheckerDescription() {
        return "Check if all modules uses the same version";
    }

    @Override
    public void checkProject(MavenProject project, Document doc, Map<String, List<Violation>> results) throws Exception {
        Node versionNode = (Node)this.getxPath().evaluate("/project/version", doc, XPathConstants.NODE);
        if (versionNode != null && !versionNode.getTextContent().equals(this.rootVersion)) {
            int lineNumber = XMLUtil.getLineNumberFromNode(versionNode);
            String msg = "This project uses a version [%s] different from the root version [%s]";
            this.addViolation(project.getFile(), results, lineNumber, String.format(msg, versionNode.getTextContent(), this.rootVersion));
        }
    }
}

