/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.io.FileUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.jboss.maven.plugins.qstools.QSToolsException;
import org.jboss.maven.plugins.qstools.checkers.QSChecker;
import org.jboss.maven.plugins.qstools.checkers.Violation;
import org.jboss.maven.plugins.qstools.config.ConfigurationProvider;
import org.jboss.maven.plugins.qstools.config.Resources;
import org.jboss.maven.plugins.qstools.config.Rules;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@Component(role=QSChecker.class, hint="ValidXMLSchemaChecker")
public class ValidXMLSchemaChecker
implements QSChecker {
    private int violationsQtd;
    @Requirement
    private ConfigurationProvider configurationProvider;
    @Requirement
    private Resources resources;
    private String checkerMessage;
    private Log log;

    @Override
    public String getCheckerDescription() {
        return "Verifies if XML files are using a valid according to XML Schema or DTD";
    }

    private void addViolation(String fileAsString, int line, String message, Map<String, List<Violation>> results) {
        ++this.violationsQtd;
        if (results.get(fileAsString) == null) {
            results.put(fileAsString, new ArrayList());
        }
        results.get(fileAsString).add(new Violation(ValidXMLSchemaChecker.class, line, message));
    }

    @Override
    public Map<String, List<Violation>> check(MavenProject project, MavenSession mavenSession, List<MavenProject> reactorProjects, Log log) throws QSToolsException {
        log.info((CharSequence)"--> This Checker can take several minutes to run");
        this.log = log;
        TreeMap<String, List<Violation>> results = new TreeMap<String, List<Violation>>();
        Rules rules = this.configurationProvider.getQuickstartsRules(project.getGroupId());
        try {
            if (rules.isCheckerIgnored(this.getClass())) {
                this.checkerMessage = "This checker is ignored for this groupId in config file.";
            } else {
                List xmlFiles = FileUtils.getFiles((File)project.getBasedir(), (String)"**/*.xml", (String)rules.getExcludes());
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema();
                for (File xml : xmlFiles) {
                    String rootDirectory = (mavenSession.getExecutionRootDirectory() + File.separator).replace("\\", "\\\\");
                    String fileAsString = xml.getAbsolutePath().replace(rootDirectory, "");
                    Validator validator = schema.newValidator();
                    validator.setResourceResolver(new URLBasedResourceResolver(xml));
                    validator.setErrorHandler(new XMLErrorHandler(fileAsString, results));
                    log.info((CharSequence)("Validating " + fileAsString));
                    try {
                        validator.validate(new StreamSource(new BufferedInputStream(new FileInputStream(xml))));
                    }
                    catch (SAXException e) {
                        this.addViolation(fileAsString, 0, e.getMessage(), results);
                    }
                }
                if (this.getCheckerMessage() != null) {
                    log.info((CharSequence)("--> Checker Message: " + this.getCheckerMessage()));
                }
                if (this.violationsQtd > 0) {
                    log.info((CharSequence)("There are " + this.violationsQtd + " checkers violations"));
                }
            }
        }
        catch (Exception e) {
            throw new QSToolsException(e);
        }
        return results;
    }

    @Override
    public int getViolatonsQtd() {
        return this.violationsQtd;
    }

    @Override
    public void resetViolationsQtd() {
        this.violationsQtd = 0;
    }

    @Override
    public String getCheckerMessage() {
        return this.checkerMessage;
    }

    private class URLBasedResourceResolver
    implements LSResourceResolver {
        private File xml;

        public URLBasedResourceResolver(File xml) {
            this.xml = xml;
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            String msg = String.format("Resolve: type=%s, ns=%s, publicId=%s, systemId=%s, baseUri=%s.", type, namespaceURI, publicId, systemId, baseURI);
            ValidXMLSchemaChecker.this.log.debug((CharSequence)msg);
            MyLSInput input = new MyLSInput();
            input.setPublicId(publicId);
            input.setSystemId(systemId);
            try {
                if (type.equals("http://www.w3.org/2001/XMLSchema")) {
                    URI uri;
                    URL url;
                    if (namespaceURI == null && systemId != null) {
                        FileInputStream fis = new FileInputStream(new File(this.xml.getParent(), systemId));
                        input.setByteStream(fis);
                        input.setSystemId(systemId);
                    } else if (namespaceURI != null && (url = (uri = new URI(baseURI == null ? "" : baseURI)).resolve(systemId == null ? "" : systemId).toURL()).getProtocol().equals("http")) {
                        InputStream is = ValidXMLSchemaChecker.this.resources.getFileInputStream(url);
                        input.setBaseURI(baseURI);
                        input.setByteStream(is);
                    }
                }
            }
            catch (IllegalArgumentException e) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return input;
        }

        private class MyLSInput
        implements LSInput {
            private Reader characterStream;
            private InputStream inputStream;
            private String stringData;
            private String systemId;
            private String publicId;
            private String baseURI;
            private String encoding;
            private boolean certified;

            private MyLSInput() {
            }

            @Override
            public Reader getCharacterStream() {
                return this.characterStream;
            }

            @Override
            public void setCharacterStream(Reader characterStream) {
                this.characterStream = characterStream;
            }

            @Override
            public InputStream getByteStream() {
                return this.inputStream;
            }

            @Override
            public void setByteStream(InputStream byteStream) {
                this.inputStream = byteStream;
            }

            @Override
            public String getStringData() {
                return this.stringData;
            }

            @Override
            public void setStringData(String stringData) {
                this.stringData = stringData;
            }

            @Override
            public String getSystemId() {
                return this.systemId;
            }

            @Override
            public void setSystemId(String systemId) {
                this.systemId = systemId;
            }

            @Override
            public String getPublicId() {
                return this.publicId;
            }

            @Override
            public void setPublicId(String publicId) {
                this.publicId = publicId;
            }

            @Override
            public String getBaseURI() {
                return this.baseURI;
            }

            @Override
            public void setBaseURI(String baseURI) {
                this.baseURI = baseURI;
            }

            @Override
            public String getEncoding() {
                return this.encoding;
            }

            @Override
            public void setEncoding(String encoding) {
                this.encoding = encoding;
            }

            @Override
            public boolean getCertifiedText() {
                return this.certified;
            }

            @Override
            public void setCertifiedText(boolean certifiedText) {
                this.certified = certifiedText;
            }
        }
    }

    private class XMLErrorHandler
    implements ErrorHandler {
        private Map<String, List<Violation>> results;
        private String fileAsString;

        public XMLErrorHandler(String fileAsString, Map<String, List<Violation>> results) {
            this.results = results;
            this.fileAsString = fileAsString;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            ValidXMLSchemaChecker.this.addViolation(this.fileAsString, exception.getLineNumber(), exception.getMessage(), this.results);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            ValidXMLSchemaChecker.this.addViolation(this.fileAsString, exception.getLineNumber(), exception.getMessage(), this.results);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            ValidXMLSchemaChecker.this.addViolation(this.fileAsString, exception.getLineNumber(), exception.getMessage(), this.results);
        }
    }
}

