/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.fixers;

import com.google.common.io.Files;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.io.FileUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.jboss.maven.plugins.qstools.config.Resources;
import org.jboss.maven.plugins.qstools.config.Rules;
import org.jboss.maven.plugins.qstools.fixers.AbstractBaseFixerAdapter;
import org.jboss.maven.plugins.qstools.fixers.QSFixer;
import org.jboss.maven.plugins.qstools.xml.PositionalXMLReader;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component(role=QSFixer.class, hint="JavaSourcesFormatFixer")
public class JavaSourcesFormatFixer
extends AbstractBaseFixerAdapter {
    @Requirement
    private Resources resources;

    @Override
    public String getFixerDescription() {
        return "Run the Eclipse source code formatter on all Java source files";
    }

    @Override
    public void fixProject(MavenProject project, org.w3c.dom.Document doc) throws Exception {
        Rules rules = this.getConfigurationProvider().getQuickstartsRules(project.getGroupId());
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        String compilerSource = rules.getExpectedCompilerSource();
        options.put("org.eclipse.jdt.core.compiler.compliance", compilerSource);
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", compilerSource);
        options.put("org.eclipse.jdt.core.compiler.source", compilerSource);
        InputStream xmlInputStream = this.resources.getExpirationalFileInputStream(new URL(rules.getEclipseFormatterProfileLocation()));
        org.w3c.dom.Document formatterSettingsDoc = PositionalXMLReader.readXML(xmlInputStream);
        NodeList settingsNodes = formatterSettingsDoc.getElementsByTagName("setting");
        for (int i = 0; i < settingsNodes.getLength(); ++i) {
            Node node = settingsNodes.item(i);
            String id = node.getAttributes().getNamedItem("id").getTextContent();
            String value = node.getAttributes().getNamedItem("value").getTextContent();
            options.put(id, value);
        }
        CodeFormatter codeFormatter = ToolFactory.createCodeFormatter((Map)options);
        List javaSources = FileUtils.getFiles((File)project.getBasedir(), (String)"**/*.java", (String)"");
        for (File javaSource : javaSources) {
            this.getLog().debug((CharSequence)("Formating " + javaSource));
            String source = Files.toString((File)javaSource, (Charset)Charset.forName("UTF-8"));
            TextEdit edit = codeFormatter.format(8, source, 0, source.length(), 0, System.getProperty("line.separator"));
            Document document = new Document(source);
            edit.apply((IDocument)document);
            Files.write((CharSequence)document.get(), (File)javaSource, (Charset)Charset.forName("UTF-8"));
        }
    }
}

