/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.jboss.maven.plugins.qstools.checkers.AbstractBaseCheckerAdapter;
import org.jboss.maven.plugins.qstools.checkers.QSChecker;
import org.jboss.maven.plugins.qstools.checkers.Violation;
import org.jboss.maven.plugins.qstools.maven.MavenDependency;
import org.jboss.maven.plugins.qstools.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component(role=QSChecker.class, hint="duplicateDependencyChecker")
public class DuplicateDependencyChecker
extends AbstractBaseCheckerAdapter {
    @Override
    public String getCheckerDescription() {
        return "Checks if the POM has any duplicate dependency";
    }

    @Override
    public void checkProject(MavenProject project, Document doc, Map<String, List<Violation>> results) throws Exception {
        HashSet<MavenDependency> declaredManagedDependencies = new HashSet<MavenDependency>();
        NodeList managedDependency = (NodeList)this.getxPath().evaluate("/project/dependencyManagement/dependencies/dependency", doc, XPathConstants.NODESET);
        for (int x = 0; x < managedDependency.getLength(); ++x) {
            Node dependency = managedDependency.item(x);
            MavenDependency mavenDependency = this.getDependencyProvider().getDependencyFromNode(project, dependency);
            int lineNumber = XMLUtil.getLineNumberFromNode(dependency);
            if (declaredManagedDependencies.add(mavenDependency)) continue;
            String msg = "Managed Dependency [%s] is declared more than once";
            this.addViolation(project.getFile(), results, lineNumber, String.format(msg, mavenDependency.getArtifactId()));
        }
        HashSet<MavenDependency> declaredDependencies = new HashSet<MavenDependency>();
        NodeList dependencies = (NodeList)this.getxPath().evaluate("/project/dependencies/dependency", doc, XPathConstants.NODESET);
        for (int x = 0; x < dependencies.getLength(); ++x) {
            Node dependency = dependencies.item(x);
            MavenDependency mavenDependency = this.getDependencyProvider().getDependencyFromNode(project, dependency);
            int lineNumber = XMLUtil.getLineNumberFromNode(dependency);
            if (declaredDependencies.add(mavenDependency)) continue;
            String msg = "Dependency [%s] is declared more than once";
            this.addViolation(project.getFile(), results, lineNumber, String.format(msg, mavenDependency.getArtifactId()));
        }
    }
}

