/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.jboss.maven.plugins.qstools.checkers.AbstractBaseCheckerAdapter;
import org.jboss.maven.plugins.qstools.checkers.QSChecker;
import org.jboss.maven.plugins.qstools.checkers.Violation;
import org.jboss.maven.plugins.qstools.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Component(role=QSChecker.class, hint="GroupIdChecker")
public class GroupIdChecker
extends AbstractBaseCheckerAdapter {
    private String groupId;

    @Override
    public String getCheckerDescription() {
        return "Check if project uses a valid Maven GroupId";
    }

    @Override
    public void checkProject(MavenProject project, Document doc, Map<String, List<Violation>> results) throws Exception {
        this.groupId = this.getConfigurationProvider().getQuickstartsRules(project.getGroupId()).getGroupId();
        Node node = (Node)this.getxPath().evaluate("/project/groupId", doc, XPathConstants.NODE);
        if (node != null && !project.getGroupId().equals(this.groupId)) {
            int lineNumber = XMLUtil.getLineNumberFromNode(node);
            this.addViolation(project.getFile(), results, lineNumber, "The project groupId[" + project.getGroupId() + "] doesn't use groupId '" + this.groupId + "'");
        }
    }
}

