/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.jboss.maven.plugins.qstools.checkers.AbstractBaseCheckerAdapter;
import org.jboss.maven.plugins.qstools.checkers.QSChecker;
import org.jboss.maven.plugins.qstools.checkers.Violation;
import org.jboss.maven.plugins.qstools.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component(role=QSChecker.class, hint="mavenCompilerChecker")
public class MavenCompilerChecker
extends AbstractBaseCheckerAdapter {
    @Override
    public String getCheckerDescription() {
        return "Check for the right usage of maven-compile-plugin";
    }

    @Override
    public void checkProject(MavenProject project, Document doc, Map<String, List<Violation>> results) throws Exception {
        int lineNumber;
        String compilerSource = this.getConfigurationProvider().getQuickstartsRules(project.getGroupId()).getExpectedCompilerSource();
        String target = project.getProperties().getProperty("maven.compiler.target");
        String compiler = project.getProperties().getProperty("maven.compiler.source");
        if (target == null || compiler == null) {
            this.addViolation(project.getFile(), results, 1, "pom.xml should define <maven.compiler.source/> and <maven.compiler.target/> properties");
        } else if (!target.equals(compilerSource) || !compiler.equals(compilerSource)) {
            this.addViolation(project.getFile(), results, 1, "<maven.compiler.source/> and <maven.compiler.target/> should be set to " + compilerSource);
        }
        Node compilerNode = (Node)this.getxPath().evaluate("/project/build/plugins/plugin[artifactId='maven-compiler-plugin']", doc, XPathConstants.NODE);
        Node compilerConfigNode = (Node)this.getxPath().evaluate("/project/build/plugins/plugin[artifactId='maven-compiler-plugin']/./configuration", doc, XPathConstants.NODE);
        int n = lineNumber = compilerConfigNode == null ? -1 : XMLUtil.getLineNumberFromNode(compilerConfigNode);
        if (compilerNode != null && compilerConfigNode == null) {
            this.addViolation(project.getFile(), results, lineNumber, "You should NOT declare 'maven-compile-plugin' without any configuration");
        } else if (compilerConfigNode != null) {
            NodeList configs = compilerConfigNode.getChildNodes();
            for (int i = 0; i < configs.getLength(); ++i) {
                Node config = configs.item(i);
                if (!config.getNodeName().equals("source") && !config.getNodeName().equals("target")) continue;
                lineNumber = compilerConfigNode == null ? -1 : XMLUtil.getLineNumberFromNode(config);
                this.addViolation(project.getFile(), results, lineNumber, "You should not define 'source' or 'target' for 'maven-compiler-plugin'");
            }
        }
    }
}

