/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.xpath.XPathConstants;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.jboss.maven.plugins.qstools.checkers.AbstractBaseCheckerAdapter;
import org.jboss.maven.plugins.qstools.checkers.QSChecker;
import org.jboss.maven.plugins.qstools.checkers.Violation;
import org.jboss.maven.plugins.qstools.maven.MavenDependency;
import org.jboss.maven.plugins.qstools.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component(role=QSChecker.class, hint="propertiesNameChecker")
public class PropertiesNameChecker
extends AbstractBaseCheckerAdapter {
    @Override
    public String getCheckerDescription() {
        return "Checks if POM properties are using standard names";
    }

    @Override
    public void checkProject(MavenProject project, Document doc, Map<String, List<Violation>> results) throws Exception {
        Properties recommendedPropertiesNames = this.getConfigurationProvider().getQuickstartsRules(project.getGroupId()).getPropertiesNames();
        NodeList dependencies = (NodeList)this.getxPath().evaluate("//dependencies/dependency| //plugins/plugin ", doc, XPathConstants.NODESET);
        for (int x = 0; x < dependencies.getLength(); ++x) {
            Node dependency = dependencies.item(x);
            MavenDependency mavenDependency = this.getDependencyProvider().getDependencyFromNode(project, dependency);
            String groupId = mavenDependency.getGroupId();
            String artifactId = mavenDependency.getArtifactId();
            String version = mavenDependency.getDeclaredVersion() == null ? null : mavenDependency.getDeclaredVersion().replaceAll("[${}]", "");
            String groupArtifactId = groupId + "|" + artifactId;
            if (groupId == null || artifactId == null || version == null || !recommendedPropertiesNames.containsKey(groupArtifactId) && !recommendedPropertiesNames.containsKey(groupId)) continue;
            String recommendedNameGA = (String)recommendedPropertiesNames.get(groupArtifactId);
            String recommendedNameG = (String)recommendedPropertiesNames.get(groupId);
            boolean wrongVersionName = false;
            if (recommendedNameGA != null && !recommendedNameGA.equals(version)) {
                wrongVersionName = true;
            }
            if (recommendedNameGA == null && recommendedNameG != null && !recommendedNameG.equals(version)) {
                wrongVersionName = true;
            }
            if (!wrongVersionName) continue;
            int lineNumber = XMLUtil.getLineNumberFromNode(dependency);
            String msg = "Version for [%s:%s:%s] isn't using the recommended property name: %s";
            String recommendedName = recommendedNameGA != null ? recommendedNameGA : recommendedNameG;
            this.addViolation(project.getFile(), results, lineNumber, String.format(msg, groupId, artifactId, mavenDependency.getDeclaredVersion(), recommendedName));
        }
    }
}

