/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.common;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.jboss.maven.plugins.qstools.QSToolsException;
import org.jboss.maven.plugins.qstools.config.ConfigurationProvider;
import org.jboss.maven.plugins.qstools.config.Rules;
import org.jboss.maven.plugins.qstools.xml.PositionalXMLReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Component(role=ArtifactIdNameUtil.class)
public class ArtifactIdNameUtil {
    protected XPath xPath = XPathFactory.newInstance().newXPath();
    @Requirement
    private ConfigurationProvider configurationProvider;

    public List<PomInformation> findAllIncorrectArtifactIdNames(List<MavenProject> reactorProjects, Rules rules) throws Exception {
        ArrayList<PomInformation> incorrectNames = new ArrayList<PomInformation>();
        try {
            File rootDirOfQuickstarts = this.getRootDirOfQuickstarts(reactorProjects.get(0));
            String artifactIdPrefix = rules.getArtifactIdPrefix();
            for (MavenProject subProject : reactorProjects) {
                Node actualArtifactId;
                Document doc = PositionalXMLReader.readXML(new FileInputStream(subProject.getFile()));
                String expectedArtifactId = this.createArtifactId(artifactIdPrefix, rootDirOfQuickstarts, subProject.getBasedir());
                if (expectedArtifactId.equals((actualArtifactId = (Node)this.xPath.evaluate("/project/artifactId", doc, XPathConstants.NODE)).getTextContent())) continue;
                int lineNumber = this.getLineNumberFromNode(actualArtifactId);
                incorrectNames.add(new PomInformation(subProject, lineNumber, expectedArtifactId, actualArtifactId.getTextContent(), subProject.getGroupId()));
            }
            return incorrectNames;
        }
        catch (Exception e) {
            throw new QSToolsException(e);
        }
    }

    private File getRootDirOfQuickstarts(MavenProject project) throws Exception {
        File dirToCheck = project.getBasedir();
        File resultDir = project.getBasedir();
        while (this.containsPomWithGroupId(dirToCheck, project.getGroupId())) {
            resultDir = dirToCheck;
            dirToCheck = dirToCheck.getParentFile();
        }
        return resultDir;
    }

    private boolean containsPomWithGroupId(File dir, String expectedGroupId) throws Exception {
        File pom = new File(dir + File.separator + "pom.xml");
        if (!pom.exists()) {
            return false;
        }
        Document doc = PositionalXMLReader.readXML(new FileInputStream(pom));
        Node actualGroupId = (Node)this.xPath.evaluate("/project/groupId", doc, XPathConstants.NODE);
        if (actualGroupId == null) {
            actualGroupId = (Node)this.xPath.evaluate("/project/parent/groupId", doc, XPathConstants.NODE);
        }
        return actualGroupId.getTextContent().equals(expectedGroupId);
    }

    private String createArtifactId(String artifactPrefix, File rootDirOfQuickstarts, File moduleBaseDir) {
        if (rootDirOfQuickstarts.equals(moduleBaseDir)) {
            return artifactPrefix + "quickstart-parent";
        }
        String modulePath = moduleBaseDir.getPath().substring(rootDirOfQuickstarts.getPath().length());
        modulePath = modulePath.substring(1);
        return artifactPrefix + modulePath.replace(File.separatorChar, '-');
    }

    protected int getLineNumberFromNode(Node node) {
        if (node == null) {
            return 0;
        }
        return (Integer)node.getUserData("beginLineNumber");
    }

    public class PomInformation {
        private MavenProject project;
        private int line;
        private String expectedArtifactId;
        private String actualArtifactId;
        private String groupId;

        public PomInformation(MavenProject project, int line, String expectedArtifactId, String actualArtifactId, String groupId) {
            this.project = project;
            this.line = line;
            this.expectedArtifactId = expectedArtifactId;
            this.actualArtifactId = actualArtifactId;
            this.groupId = groupId;
        }

        public MavenProject getProject() {
            return this.project;
        }

        public int getLine() {
            return this.line;
        }

        public String getExpectedArtifactId() {
            return this.expectedArtifactId;
        }

        public String getActualArtifactId() {
            return this.actualArtifactId;
        }

        public String getGroupId() {
            return this.groupId;
        }
    }
}

