/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.fixers;

import java.io.FileInputStream;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.jboss.maven.plugins.qstools.QSToolsException;
import org.jboss.maven.plugins.qstools.common.UnusedPropertiesUtil;
import org.jboss.maven.plugins.qstools.config.ConfigurationProvider;
import org.jboss.maven.plugins.qstools.config.Rules;
import org.jboss.maven.plugins.qstools.fixers.QSFixer;
import org.jboss.maven.plugins.qstools.xml.PositionalXMLReader;
import org.jboss.maven.plugins.qstools.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Component(role=QSFixer.class, hint="UnusedPropertiesFixer")
public class UnusedPropertiesFixer
implements QSFixer {
    protected XPath xPath = XPathFactory.newInstance().newXPath();
    @Requirement
    private ConfigurationProvider configurationProvider;
    @Requirement
    private UnusedPropertiesUtil unusedPropertiesUtil;

    @Override
    public String getFixerDescription() {
        return "Remove unused properties from pom.xml files";
    }

    @Override
    public void fix(MavenProject project, MavenSession mavenSession, List<MavenProject> reactorProjects, Log log) throws QSToolsException {
        try {
            Rules rules = this.configurationProvider.getQuickstartsRules(project.getGroupId());
            List<UnusedPropertiesUtil.PomInformation> unusedPropertyInfo = this.unusedPropertiesUtil.findUnusedProperties(reactorProjects, rules);
            for (UnusedPropertiesUtil.PomInformation pomInfo : unusedPropertyInfo) {
                Document doc = PositionalXMLReader.readXML(new FileInputStream(pomInfo.getProject().getFile()));
                Node unusedPropertyNode = (Node)this.xPath.evaluate("/project/properties/" + pomInfo.getProperty(), doc, XPathConstants.NODE);
                Node commentNode = null;
                if (unusedPropertyNode.getPreviousSibling() != null && unusedPropertyNode.getPreviousSibling() != null && unusedPropertyNode.getPreviousSibling().getPreviousSibling().getNodeType() == 8) {
                    commentNode = unusedPropertyNode.getPreviousSibling().getPreviousSibling();
                }
                if (commentNode != null) {
                    XMLUtil.removePreviousWhiteSpace(commentNode);
                    commentNode.getParentNode().removeChild(commentNode);
                }
                XMLUtil.removePreviousWhiteSpace(unusedPropertyNode);
                unusedPropertyNode.getParentNode().removeChild(unusedPropertyNode);
                XMLUtil.writeXML(doc, pomInfo.getProject().getFile());
            }
        }
        catch (Exception e) {
            throw new QSToolsException(e);
        }
    }

    @Override
    public int order() {
        return 0;
    }
}

