/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.fixers;

import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.io.FileUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.jboss.maven.plugins.qstools.fixers.AbstractBaseFixerAdapter;
import org.jboss.maven.plugins.qstools.fixers.QSFixer;
import org.w3c.dom.Document;

@Component(role=QSFixer.class, hint="XMLTabFixer")
public class XMLTabFixer
extends AbstractBaseFixerAdapter {
    @Override
    public String getFixerDescription() {
        return "Replace [TABS] by [spaces] on XMLs files";
    }

    @Override
    public void fixProject(MavenProject project, Document doc) throws Exception {
        List xmlFiles = FileUtils.getFiles((File)project.getBasedir(), (String)"**/*.xml", (String)"");
        for (File xmlSource : xmlFiles) {
            this.getLog().debug((CharSequence)("Fixing tab on " + xmlSource));
            String source = Files.toString((File)xmlSource, (Charset)Charset.forName("UTF-8"));
            String replaced = source.replace("\t", "    ");
            Files.write((CharSequence)replaced, (File)xmlSource, (Charset)Charset.forName("UTF-8"));
        }
    }
}

