/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class PositionalXMLReader {
    public static final String BEGIN_LINE_NUMBER_KEY_NAME = "beginLineNumber";
    public static final String BEGIN_COLUMN_NUMBER_KEY_NAME = "beginColumnNumber";
    public static final String END_LINE_NUMBER_KEY_NAME = "endLineNumber";
    public static final String END_COLUMN_NUMBER_KEY_NAME = "endColumnNumber";

    public static Document readXML(InputStream xmlInputStream) throws IOException, SAXException {
        Document doc;
        SAXParser parser;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            parser = factory.newSAXParser();
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setIgnoringComments(false);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            doc = docBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Can't create SAX parser / DOM builder.", e);
        }
        final Stack elementStack = new Stack();
        final StringBuilder textBuffer = new StringBuilder();
        DefaultHandler2 handler = new DefaultHandler2(){
            private Locator locator;
            private int prevLineNumber = 0;
            private int prevColumnNumber = 0;

            @Override
            public void setDocumentLocator(Locator locator) {
                this.locator = locator;
            }

            private void updateLocator() {
                this.prevLineNumber = this.locator.getLineNumber();
                this.prevColumnNumber = this.locator.getColumnNumber();
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                this.addTextIfNeeded();
                Element element = doc.createElement(qName);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    element.setAttribute(attributes.getQName(i), attributes.getValue(i));
                }
                element.setUserData(PositionalXMLReader.BEGIN_LINE_NUMBER_KEY_NAME, this.prevLineNumber, null);
                element.setUserData(PositionalXMLReader.BEGIN_COLUMN_NUMBER_KEY_NAME, this.prevColumnNumber, null);
                this.updateLocator();
                element.setUserData(PositionalXMLReader.END_LINE_NUMBER_KEY_NAME, this.prevLineNumber, null);
                element.setUserData(PositionalXMLReader.END_COLUMN_NUMBER_KEY_NAME, this.prevColumnNumber, null);
                elementStack.push(element);
            }

            @Override
            public void endElement(String uri, String localName, String qName) {
                this.addTextIfNeeded();
                Element closedEl = (Element)elementStack.pop();
                if (elementStack.isEmpty()) {
                    doc.appendChild(closedEl);
                } else {
                    Element parentEl = (Element)elementStack.peek();
                    parentEl.appendChild(closedEl);
                }
            }

            @Override
            public void startEntity(String name) throws SAXException {
            }

            @Override
            public void endEntity(String name) throws SAXException {
            }

            @Override
            public void startCDATA() {
            }

            @Override
            public void endCDATA() {
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                textBuffer.append(ch, start, length);
            }

            @Override
            public void comment(char[] ch, int start, int length) throws SAXException {
                this.addTextIfNeeded();
                this.addComment(new String(ch, start, length));
                this.updateLocator();
            }

            private void addTextIfNeeded() {
                if (textBuffer.length() > 0) {
                    Element element = (Element)elementStack.peek();
                    Text textNode = doc.createTextNode(textBuffer.toString());
                    element.appendChild(textNode);
                    textBuffer.delete(0, textBuffer.length());
                }
            }

            private void addComment(String comment) {
                if (elementStack.isEmpty()) {
                    Comment cmt = doc.createComment(comment);
                    doc.appendChild(cmt);
                } else {
                    Element element = (Element)elementStack.peek();
                    Comment commentNode = doc.createComment(comment);
                    element.appendChild(commentNode);
                }
            }
        };
        parser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
        parser.parse(xmlInputStream, (DefaultHandler)handler);
        return doc;
    }
}

