/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.xml;

import java.io.File;
import java.io.FileOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtil {
    public static void writeXML(Document doc, File file) throws Exception {
        Transformer t = TransformerFactory.newInstance().newTransformer();
        t.setOutputProperty("method", "xml");
        t.setOutputProperty("encoding", "UTF-8");
        t.setOutputProperty("indent", "yes");
        t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(new FileOutputStream(file));
        t.transform(source, result);
    }

    public static void removePreviousWhiteSpace(Node node) {
        Node prev = node.getPreviousSibling();
        if (prev != null && prev.getNodeType() == 3 && prev.getNodeValue().trim().length() == 0) {
            node.getParentNode().removeChild(prev);
        }
    }

    public static int getLineNumberFromNode(Node node) {
        if (node == null) {
            return 0;
        }
        return (Integer)node.getUserData("beginLineNumber");
    }

    public static boolean hasChildElements(Node node) {
        NodeList nodelist = node.getChildNodes();
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node childNode = nodelist.item(i);
            if (childNode.getNodeType() != 1) continue;
            return true;
        }
        return false;
    }
}

