/*
 * JBoss, Home of Professional Open Source
 * Copyright 2013, Red Hat, Inc. and/or its affiliates, and individual
 * contributors by the @authors tag. See the copyright.txt in the
 * distribution for a full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.maven.plugins.qstools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class Utils {

    /**
     * Read Ignored quickstarts
     * 
     * @return the list of ignored files
     */
    public static List<String> readIgnoredFile() {
        List<String> result = new ArrayList<String>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(".quickstarts_ignore"));
            while (br.ready()) {
                String line = br.readLine();
                result.add(line);
            }
        } catch (IOException e) {
            // No .quickstarts_ignore file found. Proceeding without one.
        } finally {
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static String getQStoolsVersion() throws IOException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(Utils.class.getResourceAsStream("/version.txt")));
            return br.readLine();
        } finally {
            if (br != null) {
                br.close();
            }
        }
    }
}
