/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.web;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Creator;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.metadata.web.spec.ServletsMetaData;
import org.jboss.metadata.web.spec.WebMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServletProcessor
extends AbstractFinderUser
implements Creator<Class<?>, WebMetaData>,
Processor<WebMetaData, Class<?>> {
    public WebServletProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    public WebMetaData create(Class<?> element) {
        DescriptionGroupMetaData descriptionGroup;
        WebServlet webServlet = (WebServlet)this.finder.getAnnotation(element, WebServlet.class);
        if (webServlet == null) {
            return null;
        }
        WebMetaData metaData = new WebMetaData();
        ServletsMetaData servlets = new ServletsMetaData();
        ServletMetaData servlet = new ServletMetaData();
        servlet.setServletClass(element.getName());
        String servletName = null;
        servletName = webServlet.name().length() == 0 ? element.getName() : webServlet.name();
        servlet.setServletName(servletName);
        if (webServlet.loadOnStartup() > 0) {
            servlet.setLoadOnStartup(webServlet.loadOnStartup());
        }
        servlet.setAsyncSupported(webServlet.asyncSupported());
        if (webServlet.initParams() != null) {
            ArrayList<ParamValueMetaData> initParams = new ArrayList<ParamValueMetaData>();
            for (WebInitParam webInitParam : webServlet.initParams()) {
                ParamValueMetaData paramValue = new ParamValueMetaData();
                paramValue.setParamName(webInitParam.name());
                paramValue.setParamValue(webInitParam.value());
                initParams.add(paramValue);
            }
            servlet.setInitParam(initParams);
        }
        if ((descriptionGroup = ProcessorUtils.getDescriptionGroup((String)webServlet.description(), (String)webServlet.displayName(), (String)webServlet.smallIcon(), (String)webServlet.largeIcon())) != null) {
            servlet.setDescriptionGroup(descriptionGroup);
        }
        servlets.add((MappableMetaData)servlet);
        metaData.setServlets(servlets);
        if (webServlet.urlPatterns() != null || webServlet.value() != null) {
            ArrayList<ServletMappingMetaData> servletMappings = new ArrayList<ServletMappingMetaData>();
            ServletMappingMetaData servletMapping = new ServletMappingMetaData();
            servletMapping.setServletName(servletName);
            ArrayList<String> urlPatterns = new ArrayList<String>();
            if (webServlet.urlPatterns() != null) {
                for (String urlPattern : webServlet.urlPatterns()) {
                    urlPatterns.add(urlPattern);
                }
            }
            if (webServlet.value() != null) {
                for (String urlPattern : webServlet.value()) {
                    urlPatterns.add(urlPattern);
                }
            }
            servletMapping.setUrlPatterns(urlPatterns);
            servletMappings.add(servletMapping);
            metaData.setServletMappings(servletMappings);
        }
        return metaData;
    }

    public void process(WebMetaData metaData, Class<?> type) {
        WebServlet annotation = (WebServlet)this.finder.getAnnotation(type, WebServlet.class);
        if (annotation == null) {
            return;
        }
        WebMetaData servletMetaData = this.create(type);
        if (metaData.getServlets() == null) {
            metaData.setServlets(servletMetaData.getServlets());
        } else {
            metaData.getServlets().addAll((Collection)((Object)servletMetaData.getServlets()));
        }
        if (metaData.getServletMappings() == null) {
            metaData.setServletMappings(servletMetaData.getServletMappings());
        } else if (servletMetaData.getServletMappings() != null) {
            metaData.getServletMappings().addAll(servletMetaData.getServletMappings());
        }
    }

    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(WebServlet.class);
    }
}

