package org.jboss.metadata.web.spec;

import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlNs;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import org.jboss.xb.annotations.JBossXmlSchema;

/**
 * TLD spec metadata.
 *
 * @author Remy Maucherat
 * @version $Revision: 81860 $
 */
@XmlRootElement(name="taglib", namespace="http://java.sun.com/JSP/TagLibraryDescriptor")
@JBossXmlSchema(
      xmlns={@XmlNs(namespaceURI = "", prefix="jee")},
      ignoreUnresolvedFieldOrClass=false,
      namespace="http://java.sun.com/JSP/TagLibraryDescriptor",
      elementFormDefault=XmlNsForm.QUALIFIED,
      normalizeSpace=true)
@XmlType(name="tldTaglibType",
      propOrder={"tlibVersion", "jspVersion", "shortName", "uri", "displayName", "smallIcon", "largeIcon", 
                 "description", "validator", "listeners", "tags"})
public class Tld12MetaData extends TldMetaData
{
   private static final long serialVersionUID = 1;

   private String displayName;
   private String smallIcon;
   private String largeIcon;
   private String description;
   
   @Override
   public String getVersion()
   {
      return "1.2";
   }

   @XmlElement(name="tag", type=Tag12MetaData.class)
   public void setTags(List<TagMetaData> tags)
   {
      super.setTags(tags);
   }

   public String getDisplayName()
   {
      return displayName;
   }
   public void setDisplayName(String displayName)
   {
      this.displayName = displayName;
   }

   public String getSmallIcon()
   {
      return smallIcon;
   }
   public void setSmallIcon(String smallIcon)
   {
      this.smallIcon = smallIcon;
   }

   public String getLargeIcon()
   {
      return largeIcon;
   }
   public void setLargeIcon(String largeIcon)
   {
      this.largeIcon = largeIcon;
   }

   public String getDescription()
   {
      return description;
   }
   public void setDescription(String description)
   {
      this.description = description;
   }
   
}
