package org.jboss.metadata.web.spec;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlNs;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import org.jboss.metadata.javaee.spec.JavaEEMetaDataConstants;
import org.jboss.xb.annotations.JBossXmlSchema;

/**
 * Web application spec metadata.
 *
 * @author Scott.Stark@jboss.org
 * @version $Revision: 81860 $
 */
@XmlRootElement(name="web-app", namespace=JavaEEMetaDataConstants.JAVAEE_NS)
@JBossXmlSchema(
      xmlns={@XmlNs(namespaceURI = JavaEEMetaDataConstants.JAVAEE_NS, prefix = "jee")},
      ignoreUnresolvedFieldOrClass=false,
      namespace=JavaEEMetaDataConstants.JAVAEE_NS,
      elementFormDefault=XmlNsForm.QUALIFIED,
      normalizeSpace=true)
@XmlType(name="web-appType",
      namespace=JavaEEMetaDataConstants.JAVAEE_NS,
      propOrder={"moduleName", "absoluteOrdering", "descriptionGroup", "name", "distributable", "contextParams", "filters", "filterMappings", "listeners", "servlets",
      "servletMappings", "sessionConfig", "mimeMappings", "welcomeFileList", "errorPages", "jspConfig", "securityConstraints",
      "loginConfig", "securityRoles", "jndiEnvironmentRefsGroup", "messageDestinations", "localEncodings", "absoluteOrdering"})
public class Web30MetaData extends WebMetaData
{
   private static final long serialVersionUID = 1;
   private boolean metadataComplete;
   private AbsoluteOrderingMetaData absoluteOrdering;
   private String moduleName;


   public boolean isMetadataComplete()
   {
      return metadataComplete;
   }
   @XmlAttribute(name="metadata-complete")
   public void setMetadataComplete(boolean metadataComplete)
   {
      this.metadataComplete = metadataComplete;
   }

   public AbsoluteOrderingMetaData getAbsoluteOrdering()
   {
      return absoluteOrdering;
   }
   @XmlElement(name="absolute-ordering")
   public void setAbsoluteOrdering(AbsoluteOrderingMetaData absoluteOrdering)
   {
      this.absoluteOrdering = absoluteOrdering;
   }

   public String getModuleName()
   {
      return moduleName;
   }
   public void setModuleName(String moduleName)
   {
      this.moduleName = moduleName;
   }

}
