/*
 * JBoss, Home of Professional Open Source
 * Copyright 2007, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.metadata.ejb.jboss.jndipolicy.plugins;

import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.EjbDeploymentSummary;

/**
 * A default jndi policy based on the ejb name.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
public class EjbNameJndiBindingPolicy
   implements DefaultJndiBindingPolicy
{

   /* (non-Javadoc)
    * @see org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy#getDefaultLocalHomeJndiName(org.jboss.metadata.ejb.jboss.jndipolicy.spi.EjbDeploymentSummary)
    */
   public String getDefaultLocalHomeJndiName(EjbDeploymentSummary summary)
   {
      return summary.getEjbName() + "LocalHome";
   }

   /* (non-Javadoc)
    * @see org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy#getDefaultLocalJndiName(org.jboss.metadata.ejb.jboss.jndipolicy.spi.EjbDeploymentSummary)
    */
   public String getDefaultLocalJndiName(EjbDeploymentSummary summary)
   {
      return summary.getEjbName() + "Local";
   }

   /* (non-Javadoc)
    * @see org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy#getDefaultRemoteHomeJndiName(org.jboss.metadata.ejb.jboss.jndipolicy.spi.EjbDeploymentSummary)
    */
   public String getDefaultRemoteHomeJndiName(EjbDeploymentSummary summary)
   {
      return summary.getEjbName() + "Home";
   }

   /* (non-Javadoc)
    * @see org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy#getDefaultRemoteJndiName(org.jboss.metadata.ejb.jboss.jndipolicy.spi.EjbDeploymentSummary)
    */
   public String getDefaultRemoteJndiName(EjbDeploymentSummary summary)
   {
      return summary.getEjbName() + "Remote";
   }

   /* (non-Javadoc)
    * @see org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy#getJndiName(org.jboss.metadata.ejb.jboss.jndipolicy.spi.EjbDeploymentSummary)
    */
   public String getJndiName(EjbDeploymentSummary summary)
   {
      return summary.getEjbName();
   }

}
