/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.EJBClassProcessor;
import org.jboss.metadata.annotation.creator.EJBFieldProcessor;
import org.jboss.metadata.annotation.creator.EJBMethodProcessor;
import org.jboss.metadata.annotation.creator.EJBsClassProcessor;
import org.jboss.metadata.annotation.creator.PersistenceContextClassProcessor;
import org.jboss.metadata.annotation.creator.PersistenceContextFieldProcessor;
import org.jboss.metadata.annotation.creator.PersistenceContextMethodProcessor;
import org.jboss.metadata.annotation.creator.PostConstructMethodProcessor;
import org.jboss.metadata.annotation.creator.PreDestroyMethodProcessor;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ResourceClassProcessor;
import org.jboss.metadata.annotation.creator.ResourceFieldProcessor;
import org.jboss.metadata.annotation.creator.ResourceMethodProcessor;
import org.jboss.metadata.annotation.creator.ResourcesClassProcessor;
import org.jboss.metadata.annotation.creator.WebServiceRefFieldProcessor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.javaee.spec.AnnotatedEJBReferencesMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;
import org.jboss.metadata.javaee.spec.PersistenceContextReferencesMetaData;
import org.jboss.metadata.javaee.spec.PersistenceUnitReferencesMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironmentRefsGroupMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferencesMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComponentProcessor<MD>
extends AbstractFinderUser {
    private static Logger log = Logger.getLogger(AbstractComponentProcessor.class);
    protected Map<Class<?>, List<Processor<Object, Class<?>>>> typeProcessors;
    protected Map<Class<?>, List<Processor<Object, Field>>> fieldProcessors;
    protected Map<Class<?>, List<Processor<Object, Method>>> methodProcessors;
    protected Set<Class> boundedTypes = new HashSet<Class>();

    public AbstractComponentProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
        this.typeProcessors = new HashMap();
        this.fieldProcessors = new HashMap();
        this.methodProcessors = new HashMap();
        this.addMethodProcessor(new ResourceMethodProcessor(finder));
        this.addFieldProcessor(new ResourceFieldProcessor(finder));
        this.addTypeProcessor(new ResourceClassProcessor(finder));
        this.addTypeProcessor(new ResourcesClassProcessor(finder));
        this.addMethodProcessor(new EJBMethodProcessor(finder));
        this.addFieldProcessor(new EJBFieldProcessor(finder));
        this.addTypeProcessor(new EJBClassProcessor(finder));
        this.addTypeProcessor(new EJBsClassProcessor(finder));
        this.addFieldProcessor(new PersistenceContextFieldProcessor(finder));
        this.addMethodProcessor(new PersistenceContextMethodProcessor(finder));
        this.addTypeProcessor(new PersistenceContextClassProcessor(finder));
        this.addMethodProcessor(new PostConstructMethodProcessor(finder));
        this.addMethodProcessor(new PreDestroyMethodProcessor(finder));
        this.addFieldProcessor(new WebServiceRefFieldProcessor(finder));
    }

    public void addFieldProcessor(Processor processor) {
        Class processorType = this.getProcessorMetaDataType(processor);
        log.debug((Object)("addFieldProcessor: " + processor + ", for type: " + processorType));
        List<Processor<Object, Field>> processors = this.fieldProcessors.get(processorType);
        if (processors == null) {
            processors = new ArrayList<Processor<Object, Field>>();
            this.fieldProcessors.put(processorType, processors);
        }
        processors.add(processor);
    }

    public void addMethodProcessor(Processor processor) {
        Class processorType = this.getProcessorMetaDataType(processor);
        log.debug((Object)("addMethodProcessor: " + processor + ", for type: " + processorType));
        List<Processor<Object, Method>> processors = this.methodProcessors.get(processorType);
        if (processors == null) {
            processors = new ArrayList<Processor<Object, Method>>();
            this.methodProcessors.put(processorType, processors);
        }
        processors.add(processor);
    }

    public void addTypeProcessor(Processor processor) {
        Class processorType = this.getProcessorMetaDataType(processor);
        log.debug((Object)("addTypeProcessor: " + processor + ", for type: " + processorType));
        List<Processor<Object, Class<?>>> processors = this.typeProcessors.get(processorType);
        if (processors == null) {
            processors = new ArrayList();
            this.typeProcessors.put(processorType, processors);
        }
        processors.add(processor);
    }

    public void process(RemoteEnvironmentRefsGroupMetaData metaData, Class<?> type) {
        this.processClass(metaData, type, RemoteEnvironmentRefsGroupMetaData.class);
        AnnotatedEJBReferencesMetaData aejbRefs = metaData.getAnnotatedEjbReferences();
        if (aejbRefs == null) {
            aejbRefs = new AnnotatedEJBReferencesMetaData();
            metaData.setAnnotatedEjbReferences(aejbRefs);
        }
        this.processClass(aejbRefs, type);
        PersistenceUnitReferencesMetaData puRefs = metaData.getPersistenceUnitRefs();
        if (puRefs == null) {
            puRefs = new PersistenceUnitReferencesMetaData();
            metaData.setPersistenceUnitRefs(puRefs);
        }
        this.processClass(puRefs, type);
        ServiceReferencesMetaData wsRefs = metaData.getServiceReferences();
        if (wsRefs == null) {
            wsRefs = new ServiceReferencesMetaData();
            metaData.setServiceReferences(wsRefs);
        }
        this.processClass(wsRefs, type);
    }

    public void process(EnvironmentRefsGroupMetaData metaData, Class<?> type) {
        this.process((MD)metaData, type);
        PersistenceContextReferencesMetaData pcRefs = metaData.getPersistenceContextRefs();
        if (pcRefs == null) {
            pcRefs = new PersistenceContextReferencesMetaData();
            metaData.setPersistenceContextRefs(pcRefs);
        }
        this.processClass(pcRefs, type);
    }

    public void process(MD metaData, Class<?> type) {
        this.processClass(metaData, type);
    }

    protected <T> void processClass(T metaData, Class<?> cls) {
        Class<?> type = metaData.getClass();
        boolean trace = log.isTraceEnabled();
        int processorCount = this.processClass(metaData, cls, type);
        if (trace) {
            log.trace((Object)("Found " + processorCount + " processors for type: " + type));
        }
        for (type = type.getSuperclass(); !this.boundedTypes.contains(type) && type != Object.class; type = type.getSuperclass()) {
        }
        if (type != Object.class) {
            if (trace) {
                log.trace((Object)("Reprocessing class using bounded processor type: " + type));
            }
            this.processClass(metaData, cls, type);
        }
    }

    private <T> int processClass(T metaData, Class<?> cls, Class processorType) {
        List<Processor<Object, Method>> mps;
        List<Processor<Object, Field>> fps;
        List<Processor<Object, Class<?>>> tps;
        boolean trace = log.isTraceEnabled();
        int processorCount = 0;
        if (trace) {
            log.trace((Object)("processClass for metaData: " + processorType + ", class: " + cls));
        }
        if ((tps = this.typeProcessors.get(processorType)) != null) {
            processorCount += tps.size();
            if (trace) {
                log.trace((Object)("typeProcessors(" + tps.size() + ") for metaData: " + tps));
            }
            for (Processor<Object, Class<?>> processor : tps) {
                processor.process(metaData, cls);
            }
            for (Class<?> intf : cls.getInterfaces()) {
                for (Processor<Object, Class<?>> processor : tps) {
                    processor.process(metaData, intf);
                }
            }
        }
        if ((fps = this.fieldProcessors.get(processorType)) != null) {
            processorCount += fps.size();
            if (trace) {
                log.trace((Object)("fieldProcessors(" + fps.size() + ") for metaData: " + fps));
            }
            Field[] fields = new Field[]{};
            try {
                fields = cls.getDeclaredFields();
            }
            catch (Throwable e) {
                log.debug((Object)("Failed to get DeclaredFields for: " + cls), e);
            }
            for (Field field : fields) {
                for (Processor<Object, Field> processor : fps) {
                    processor.process(metaData, field);
                }
            }
        }
        if ((mps = this.methodProcessors.get(processorType)) != null) {
            processorCount += mps.size();
            if (trace) {
                log.trace((Object)("methodProcessors(" + mps.size() + ") for metaData: " + mps));
            }
            Method[] methods = new Method[]{};
            try {
                methods = cls.getDeclaredMethods();
            }
            catch (Throwable e) {
                log.debug((Object)("Failed to get DeclaredMethods for: " + cls), e);
            }
            for (Method method : methods) {
                if (trace) {
                    log.trace((Object)("process method " + method));
                }
                for (Processor<Object, Method> processor : mps) {
                    processor.process(metaData, method);
                }
            }
        }
        if (cls.getSuperclass() != null && cls.getSuperclass() != Object.class) {
            processorCount += this.processClass(metaData, cls.getSuperclass(), processorType);
        }
        return processorCount;
    }

    protected Class getProcessorMetaDataType(Processor processor) {
        Type[] interfaces = processor.getClass().getGenericInterfaces();
        Type processorType = null;
        for (Type t : interfaces) {
            ParameterizedType pt = (ParameterizedType)t;
            Type rawType = pt.getRawType();
            if (!(rawType instanceof Class) || !((Class)rawType).getName().equals("org.jboss.metadata.annotation.creator.Processor")) continue;
            processorType = t;
            break;
        }
        if (processorType == null) {
            throw new IllegalStateException("No generic Processor interface found on: " + processor);
        }
        ParameterizedType pt = (ParameterizedType)processorType;
        Type t0 = pt.getActualTypeArguments()[0];
        Class t = null;
        if (t0 instanceof Class) {
            t = (Class)t0;
        } else if (t0 instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)t0;
            t = (Class)tv.getBounds()[0];
            this.boundedTypes.add(t);
        }
        return t;
    }
}

