/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb;

import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import javax.ejb.EJBLocalObject;
import javax.ejb.Remote;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplicitLocalProcessor
extends AbstractFinderUser
implements Processor<SessionBeanMetaData, Class<?>> {
    public ImplicitLocalProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    @Override
    public void process(SessionBeanMetaData metaData, Class<?> type) {
        if (metaData.getBusinessLocals() != null && metaData.getBusinessLocals().size() > 0) {
            return;
        }
        if (metaData.getBusinessRemotes() != null && metaData.getBusinessRemotes().size() > 0) {
            return;
        }
        if (!metaData.getEjbClass().equals(type.getName())) {
            return;
        }
        Class<?> businessInterface = ImplicitLocalProcessor.extractInterface(type.getInterfaces());
        if (businessInterface == null) {
            return;
        }
        Remote remote = this.finder.getAnnotation(businessInterface, Remote.class);
        if (remote != null) {
            return;
        }
        if (EJBLocalObject.class.isAssignableFrom(businessInterface)) {
            throw new IllegalStateException("EJB 3.0 Core Specification Violation (4.6.6): The session bean\u00e2\u20ac\u2122s business interface " + businessInterface + " must not extend the javax.ejb.EJBLocalObject interface.");
        }
        if (metaData.getBusinessLocals() == null) {
            metaData.setBusinessLocals(new BusinessLocalsMetaData());
        }
        metaData.getBusinessLocals().add(businessInterface.getName());
    }

    private static Class<?> extractInterface(Class<?> ... interfaces) {
        Class<?> iFace = null;
        for (Class<?> candidate : interfaces) {
            if (Serializable.class.equals(candidate) || Externalizable.class.equals(candidate) || candidate.getName().startsWith("javax.ejb") || candidate.getName().startsWith("org.jboss.aop")) continue;
            if (iFace == null) {
                iFace = candidate;
                continue;
            }
            return null;
        }
        return iFace;
    }
}

