/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ws;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import javax.jws.HandlerChain;
import org.jboss.logging.Logger;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ws.ServiceReferenceHandlerChainsWrapper;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlerChainsMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceHandlerChainProcessor<E extends AnnotatedElement>
extends AbstractFinderUser
implements Processor<ServiceReferenceMetaData, E> {
    private static Logger log = Logger.getLogger(WebServiceHandlerChainProcessor.class);
    private static final DefaultSchemaResolver resolver = new DefaultSchemaResolver();

    public WebServiceHandlerChainProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    @Override
    public void process(ServiceReferenceMetaData refs, E type) {
        HandlerChain annotation = this.finder.getAnnotation(type, HandlerChain.class);
        if (annotation == null) {
            return;
        }
        if (annotation.file() != null && annotation.file().length() > 1) {
            log.trace((Object)("processing HandlerChain for element: " + type));
            this.process(refs, type, annotation);
        }
    }

    protected void process(ServiceReferenceMetaData refs, E element, HandlerChain annotation) {
        String fileName = annotation.file();
        ServiceReferenceHandlerChainsMetaData handlerChains = null;
        try {
            InputStream in = this.getResourceInputStream(element, fileName);
            handlerChains = this.unmarshall(in);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not process file: " + fileName, e);
        }
        if (handlerChains == null) {
            return;
        }
        if (refs.getHandlerChains() != null) {
            ServiceReferenceHandlerChainsMetaData merged = new ServiceReferenceHandlerChainsMetaData();
            merged.merge(handlerChains, refs.getHandlerChains());
            refs.setHandlerChains(merged);
        } else {
            refs.setHandlerChains(handlerChains);
        }
    }

    protected ServiceReferenceHandlerChainsMetaData unmarshall(InputStream in) throws JBossXBException {
        if (in == null) {
            throw new IllegalArgumentException("InputStream may not be null.");
        }
        Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
        return (ServiceReferenceHandlerChainsMetaData)unmarshaller.unmarshal(in, (SchemaBindingResolver)resolver);
    }

    protected InputStream getResourceInputStream(E type, String file) throws MalformedURLException, IOException, IllegalStateException {
        URL url;
        if (file.startsWith("http://") && (url = new URL(file)) != null) {
            return url.openStream();
        }
        String fileName = file;
        Class<?> declaredClass = this.resolveDeclaringClass(type);
        InputStream in = declaredClass.getResourceAsStream(fileName);
        if (in != null) {
            return in;
        }
        if (!file.startsWith("/")) {
            String baseName = declaredClass.getName();
            int index = baseName.lastIndexOf(46);
            if (index != -1) {
                fileName = baseName.substring(0, index).replace('.', '/') + "/" + file;
            }
        } else {
            fileName = file.substring(1);
        }
        in = declaredClass.getResourceAsStream(fileName);
        if (in != null) {
            return in;
        }
        throw new IllegalStateException("could not find file: " + file);
    }

    private Class<?> resolveDeclaringClass(E element) {
        if (element == null) {
            throw new IllegalArgumentException("element may not be null.");
        }
        if (element instanceof Class) {
            return (Class)element;
        }
        if (element instanceof Method) {
            return ((Method)element).getDeclaringClass();
        }
        return ((Field)element).getDeclaringClass();
    }

    static {
        resolver.addClassBinding("http://java.sun.com/xml/ns/javaee", ServiceReferenceHandlerChainsWrapper.class);
    }
}

