/*
 * JBoss, Home of Professional Open Source
 * Copyright 2007, Red Hat Middleware LLC, and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.metadata.annotation.creator.ejb;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Creator;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.spec.EjbJar30MetaData;
import org.jboss.metadata.ejb.spec.EjbJar3xMetaData;

/**
 * Create the correct meta data for a set of annotated classes.
 *
 * @author <a href="mailto:carlo.dewolf@jboss.com">Carlo de Wolf</a>
 * @version $Revision: 67346 $
 */
public class EjbJar30Creator extends AbstractFinderUser
   implements Creator<Collection<Class<?>>, EjbJar30MetaData>
{
   private List<Processor<EjbJar3xMetaData, Class<?>>> processors;
   
   public EjbJar30Creator(AnnotationFinder<AnnotatedElement> finder)
   {
      super(finder);
      
      processors = new ArrayList<Processor<EjbJar3xMetaData,Class<?>>>();
      processors.add(new StatefulProcessor(finder));
      processors.add(new StatelessProcessor(finder));
      processors.add(new MessageDrivenProcessor(finder));
      processors.add(new EntityProcessor(finder));
      processors.add(new ApplicationExceptionProcessor(finder));
   }
   
   public EjbJar30MetaData create(Collection<Class<?>> classes)
   {
      EjbJar30MetaData metaData = new EjbJar30MetaData();
      metaData.setVersion("3.0");
      
      for(Class<?> cls : classes)
      {
         for(Processor<EjbJar3xMetaData, Class<?>> processor : processors)
         {
            processor.process(metaData, cls);
         }
      }
      
      return metaData;
   }
}
