/*
 * JBoss, Home of Professional Open Source
 * Copyright 2007, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.metadata.annotation.creator.web;

import java.lang.reflect.AnnotatedElement;
import java.util.Collection;

import org.jboss.metadata.annotation.creator.AbstractCreator;
import org.jboss.metadata.annotation.creator.Creator;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.web.spec.Web25MetaData;
import org.jboss.metadata.web.spec.WebMetaData;

/**
 * Create a Web25MetaData instance from the class annotations
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 76002 $
 */
public class Web25MetaDataCreator extends AbstractCreator<WebMetaData>
      implements Creator<Collection<Class<?>>, Web25MetaData>
{
   public Web25MetaDataCreator(AnnotationFinder<AnnotatedElement> finder)
   {
      super(finder);
      addProcessor(new WebComponentProcessor(finder));
   }

   public Web25MetaData create(Collection<Class<?>> classes)
   {
      // Don't create meta data for a empty collection
      if(classes == null || classes.isEmpty())
         return null;
      
      // Create meta data
      Web25MetaData metaData = new Web25MetaData();
      metaData.setVersion("2.5");

      // Process classes
      for (Class<?> cls : classes)
         process(metaData, cls);

      return metaData;
   }

}
