/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb.jboss;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import org.jboss.annotation.javaee.Descriptions;
import org.jboss.ejb3.annotation.RemoteBinding;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.jboss.RemoteBindingMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteBindingProcessor
extends AbstractFinderUser
implements Processor<JBossSessionBeanMetaData, Class<?>> {
    protected RemoteBindingProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    @Override
    public void process(JBossSessionBeanMetaData metaData, Class<?> type) {
        RemoteBinding annotation = this.finder.getAnnotation(type, RemoteBinding.class);
        if (annotation == null) {
            return;
        }
        this.process(metaData, type, annotation);
    }

    public void process(JBossSessionBeanMetaData metaData, Class<?> type, RemoteBinding annotation) {
        if (metaData.getRemoteBindings() == null) {
            metaData.setRemoteBindings(new ArrayList<RemoteBindingMetaData>());
        }
        RemoteBindingMetaData remote = this.createBindingMetaData(type, annotation);
        metaData.getRemoteBindings().add(remote);
    }

    protected RemoteBindingMetaData createBindingMetaData(Class<?> type, RemoteBinding annotation) {
        RemoteBindingMetaData remote = new RemoteBindingMetaData();
        remote.setJndiName(annotation.jndiBinding());
        remote.setClientBindUrl(annotation.clientBindUrl());
        remote.setInterceptorStack(annotation.interceptorStack());
        remote.setProxyFactory(annotation.factory());
        Descriptions descriptions = ProcessorUtils.getDescription(" @RemoteBinding for class " + type.getSimpleName());
        remote.setDescriptions(descriptions);
        return remote;
    }

    @Override
    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(RemoteBinding.class);
    }
}

