/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.process.processor.ejb.jboss;

import javax.ejb.EJBLocalObject;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBoss50MetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.lang.ClassHelper;
import org.jboss.metadata.process.ProcessingException;
import org.jboss.metadata.process.processor.JBossMetaDataProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetDefaultLocalBusinessInterfaceProcessor
implements JBossMetaDataProcessor<JBoss50MetaData> {
    private static final Logger log = Logger.getLogger(SetDefaultLocalBusinessInterfaceProcessor.class);
    public static final SetDefaultLocalBusinessInterfaceProcessor INSTANCE = new SetDefaultLocalBusinessInterfaceProcessor();

    @Override
    public JBoss50MetaData process(JBoss50MetaData metadata) throws ProcessingException {
        assert (metadata != null) : "Specified metadata was null";
        JBossEnterpriseBeansMetaData ejbs = metadata.getEnterpriseBeans();
        for (JBossEnterpriseBeanMetaData ejb : ejbs) {
            Class<?> businessInterface;
            if (!ejb.isSession()) continue;
            JBossSessionBeanMetaData smd = (JBossSessionBeanMetaData)ejb;
            String ejbImplementationClassName = smd.getEjbClass();
            ClassLoader tcl = Thread.currentThread().getContextClassLoader();
            Class<?> ejbImplementationClass = null;
            try {
                ejbImplementationClass = Class.forName(ejbImplementationClassName, false, tcl);
            }
            catch (ClassNotFoundException e) {
                throw new ProcessingException(this + " must be run on metadata while the deployment's ClassLoader is the Thread Context ClassLoader");
            }
            if (smd.getBusinessLocals() != null && smd.getBusinessLocals().size() > 0 || smd.getBusinessRemotes() != null && smd.getBusinessRemotes().size() > 0 || (businessInterface = ClassHelper.extractInterface(ejbImplementationClass.getInterfaces())) == null) continue;
            if (EJBLocalObject.class.isAssignableFrom(businessInterface)) {
                throw new IllegalStateException("EJB 3.0 Core Specification Violation (4.6.6): The session bean\u2019s business interface " + businessInterface + " must not extend the javax.ejb.EJBLocalObject interface.");
            }
            if (smd.getBusinessLocals() == null) {
                smd.setBusinessLocals(new BusinessLocalsMetaData());
            }
            smd.getBusinessLocals().add(businessInterface.getName());
        }
        return metadata;
    }
}

