/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.aspects.jmx;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.jboss.aop.microcontainer.aspects.jmx.JMX;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.logging.Logger;
import org.jboss.metadata.spi.MetaData;

public class JMXLifecycleCallback {
    private static final Logger log = Logger.getLogger(JMXLifecycleCallback.class);
    private MBeanServer server;

    public void setMbeanServer(MBeanServer server) {
        this.server = server;
    }

    public void install(ControllerContext context) throws Exception {
        this.validateServer();
        JMX jmx = this.readJmxAnnotation(context);
        ObjectName objectName = this.createObjectName(context, jmx);
        Class intfClass = null;
        boolean registerDirectly = false;
        if (jmx != null) {
            intfClass = jmx.exposedInterface();
            registerDirectly = jmx.registerDirectly();
        }
        Object mbean = registerDirectly ? context.getTarget() : new StandardMBean(context.getTarget(), intfClass);
        this.server.registerMBean(mbean, objectName);
        log.debug((Object)("Registered MBean " + objectName));
    }

    public void uninstall(ControllerContext context) throws Exception {
        this.validateServer();
        JMX jmx = this.readJmxAnnotation(context);
        ObjectName objectName = this.createObjectName(context, jmx);
        log.debug((Object)("Unregistering MBean " + objectName));
        this.server.unregisterMBean(objectName);
    }

    private void validateServer() {
        if (this.server == null) {
            throw new RuntimeException("No MBeanServer was injected");
        }
    }

    private JMX readJmxAnnotation(ControllerContext context) throws Exception {
        MetaData metaData = context.getScopeInfo().getMetaData();
        if (metaData != null) {
            return (JMX)metaData.getAnnotation(JMX.class);
        }
        return null;
    }

    private ObjectName createObjectName(ControllerContext context, JMX jmx) throws Exception {
        String jmxName;
        ObjectName objectName = null;
        if (jmx != null && (jmxName = jmx.name()) != null && jmxName.length() > 0) {
            objectName = new ObjectName(jmxName);
        }
        if (objectName == null) {
            String name = (String)context.getName();
            objectName = name.contains(":") ? new ObjectName(name) : new ObjectName("test:name='" + name + "'");
        }
        return objectName;
    }
}

