/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.integration;

import java.lang.reflect.Constructor;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ConstructorInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.ConstructorInvocation;
import org.jboss.aop.microcontainer.beans.AspectManagerFactory;
import org.jboss.aop.proxy.container.AOPProxyFactory;
import org.jboss.aop.proxy.container.AOPProxyFactoryParameters;
import org.jboss.aop.proxy.container.ContainerCache;
import org.jboss.aop.proxy.container.GeneratedAOPProxyFactory;
import org.jboss.joinpoint.plugins.BasicConstructorJoinPoint;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.metadata.spi.stack.MetaDataStack;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;

public class AOPConstructorJoinpoint
extends BasicConstructorJoinPoint {
    AOPProxyFactory proxyFactory = new GeneratedAOPProxyFactory();

    public AOPConstructorJoinpoint(org.jboss.reflect.spi.ConstructorInfo constructorInfo) {
        super(constructorInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dispatch() throws Throwable {
        Class clazz = this.constructorInfo.getDeclaringClass().getType();
        MetaData metaData = MetaDataStack.peek();
        AspectManager manager = AspectManagerFactory.getAspectManager(metaData);
        MetaDataStack.mask();
        try {
            boolean hasInstanceMetaData = this.hasInstanceOrJoinpointMetaData(metaData);
            ContainerCache cache = ContainerCache.initialise((AspectManager)manager, (Class)clazz, (MetaData)metaData, (boolean)hasInstanceMetaData);
            AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
            Object target = this.createTarget(cache, params);
            params.setProxiedClass(target.getClass());
            params.setMetaData(metaData);
            params.setTarget(target);
            params.setContainerCache(cache);
            params.setMetaDataHasInstanceLevelData(hasInstanceMetaData);
            Object object = this.proxyFactory.createAdvisedProxy(params);
            return object;
        }
        finally {
            MetaDataStack.unmask();
        }
    }

    private boolean hasInstanceOrJoinpointMetaData(MetaData metaData) {
        if (metaData == null) {
            return false;
        }
        MetaData instanceMetaData = metaData.getScopeMetaData(CommonLevels.INSTANCE);
        if (instanceMetaData != null && !instanceMetaData.isEmpty()) {
            return true;
        }
        return this.hasMethodMetaData(metaData);
    }

    private boolean hasMethodMetaData(MetaData metaData) {
        for (ClassInfo info = this.constructorInfo.getDeclaringClass(); info != null; info = info.getSuperclass()) {
            MethodInfo[] methods = info.getDeclaredMethods();
            if (methods == null) continue;
            for (MethodInfo mi : methods) {
                if (!this.methodHasAnnotations(metaData, mi)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean methodHasAnnotations(MetaData metaData, MethodInfo mi) {
        MethodSignature sig = new MethodSignature(mi);
        MetaData methodMD = metaData.getComponentMetaData((Signature)sig);
        if (methodMD != null) {
            return methodMD.getAnnotations() != MetaData.NO_ANNOTATIONS;
        }
        return false;
    }

    private Object createTarget(ContainerCache cache, AOPProxyFactoryParameters params) throws Throwable {
        Advisor advisor = cache.getAdvisor();
        if (advisor != null) {
            Interceptor[] interceptors;
            ConstructorInfo aopinfo = this.findAopConstructorInfo(advisor);
            Interceptor[] interceptorArray = interceptors = aopinfo != null ? aopinfo.getInterceptors() : null;
            if (interceptors != null) {
                ConstructorInvocation inv = new ConstructorInvocation(aopinfo, aopinfo.getInterceptors());
                inv.setArguments(this.getArguments());
                return inv.invokeNext();
            }
            if (this.getConstructorInfo().getParameterTypes().length > 0) {
                Constructor<?> constructor = null;
                if (aopinfo == null) {
                    Constructor<?>[] ctors;
                    Class clazz = advisor.getClazz();
                    for (Constructor<?> ctor : ctors = clazz.getConstructors()) {
                        if (!this.matchConstructor(ctor)) continue;
                        constructor = ctor;
                        break;
                    }
                } else {
                    constructor = aopinfo.getConstructor();
                }
                params.setCtor((Class[])constructor.getParameterTypes(), this.getArguments());
            }
        }
        return super.dispatch();
    }

    private ConstructorInfo findAopConstructorInfo(Advisor advisor) {
        ConstructorInfo[] infos = advisor.getConstructorInfos();
        for (int i = 0; i < infos.length; ++i) {
            if (!this.matchConstructor(infos[i].getConstructor())) continue;
            return infos[i];
        }
        return null;
    }

    private boolean matchConstructor(Constructor ctor) {
        Class<?>[] ctorParams;
        TypeInfo[] params = this.constructorInfo.getParameterTypes();
        if (params.length == (ctorParams = ctor.getParameterTypes()).length) {
            boolean match = true;
            for (int p = 0; p < params.length; ++p) {
                if (params[p].getName().equals(ctorParams[p].getName())) continue;
                match = false;
                break;
            }
            if (match) {
                return true;
            }
        }
        return false;
    }
}

