/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.beans;

import java.util.ArrayList;
import java.util.List;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.array.Type;
import org.jboss.aop.microcontainer.beans.Binding;
import org.jboss.aop.microcontainer.beans.BindingEntry;
import org.jboss.logging.Logger;
import org.jboss.util.id.GUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayBinding
implements Binding {
    private static final Logger log = Logger.getLogger(ArrayBinding.class);
    AspectManager manager;
    String name = GUID.asString();
    String type;
    List<BindingEntry> advices;

    public AspectManager getManager() {
        return this.manager;
    }

    public void setManager(AspectManager manager) {
        this.manager = manager;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<BindingEntry> getAdvices() {
        return this.advices;
    }

    public void setAdvices(List<BindingEntry> advices) {
        this.advices = advices;
    }

    public void start() throws Exception {
        if (this.manager == null) {
            throw new IllegalArgumentException("Null manager");
        }
        if (this.type == null) {
            throw new IllegalArgumentException("Null type");
        }
        Type theType = Type.valueOf((String)this.type);
        ArrayList<InterceptorFactory> interceptors = null;
        if (this.advices != null) {
            interceptors = new ArrayList<InterceptorFactory>();
            for (BindingEntry entry : this.advices) {
                InterceptorFactory[] factories;
                entry.start();
                for (InterceptorFactory ifac : factories = entry.getInterceptorFactories()) {
                    interceptors.add(ifac);
                }
            }
        }
        InterceptorFactory[] facs = interceptors != null ? interceptors.toArray(new InterceptorFactory[interceptors.size()]) : new InterceptorFactory[]{};
        org.jboss.aop.array.ArrayBinding binding = new org.jboss.aop.array.ArrayBinding(this.name, facs, theType);
        this.manager.addArrayBinding(binding);
        log.debug((Object)("Bound array binding " + this.name));
    }

    public void stop() throws Exception {
        this.manager.removeArrayBinding(this.name);
        if (this.advices != null) {
            for (BindingEntry entry : this.advices) {
                entry.stop();
            }
        }
    }

    public void uninstall() throws Exception {
        this.stop();
    }

    @Override
    public void rebind() throws Exception {
        this.stop();
        this.start();
    }
}

