/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.beans;

import java.io.Reader;
import java.io.StringReader;
import org.jboss.aop.AspectManager;
import org.jboss.aop.pointcut.ast.ASTStart;
import org.jboss.aop.pointcut.ast.ParseException;
import org.jboss.aop.pointcut.ast.TypeExpressionParser;
import org.jboss.util.id.GUID;

public class ArrayReplacement {
    AspectManager manager;
    String name = GUID.asString();
    String classes;
    String expr;

    public AspectManager getManager() {
        return this.manager;
    }

    public void setManager(AspectManager manager) {
        this.manager = manager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClasses() {
        return this.classes;
    }

    public void setClasses(String classes) {
        this.classes = classes;
    }

    public String getExpr() {
        return this.expr;
    }

    public void setExpr(String expr) {
        this.expr = expr;
    }

    public void start() {
        if (this.manager == null) {
            throw new IllegalArgumentException("Null manager");
        }
        if (this.classes == null && this.expr == null) {
            throw new IllegalArgumentException("Must define either expr or classes");
        }
        if (this.classes != null && this.expr != null) {
            throw new IllegalArgumentException("Cannot define both expr and classes");
        }
        org.jboss.aop.array.ArrayReplacement pcut = null;
        if (this.classes != null) {
            pcut = new org.jboss.aop.array.ArrayReplacement(this.name, this.classes);
        } else {
            try {
                ASTStart start = new TypeExpressionParser((Reader)new StringReader(this.expr)).Start();
                pcut = new org.jboss.aop.array.ArrayReplacement(this.name, start);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Could not parse type expression " + this.expr, e);
            }
        }
        this.manager.addArrayReplacement(pcut);
    }

    public void stop() {
        this.manager.removeArrayReplacement(this.name);
    }
}

