/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.beans;

import org.jboss.aop.AspectManager;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.pointcut.PointcutExpression;
import org.jboss.aop.pointcut.ast.ParseException;
import org.jboss.util.id.GUID;

public class Prepare {
    protected AspectManager manager;
    protected String name = GUID.asString();
    protected String expr;

    public AspectManager getManager() {
        return this.manager;
    }

    public void setManager(AspectManager manager) {
        this.manager = manager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getExpr() {
        return this.expr;
    }

    public void setExpr(String pointcut) {
        this.expr = pointcut;
    }

    public void start() {
        if (this.manager == null) {
            throw new IllegalArgumentException("Null manager");
        }
        if (this.expr == null || this.expr.length() == 0) {
            throw new IllegalArgumentException("No pointcut");
        }
        PointcutExpression p = null;
        try {
            p = new PointcutExpression(this.name, this.expr);
        }
        catch (ParseException ex) {
            throw new RuntimeException("<pointcut name='" + this.name + "' expr='" + this.expr + "'/> failed", ex);
        }
        this.manager.addPointcut((Pointcut)p);
    }

    public void stop() {
        this.manager.removePointcut(this.name);
    }
}

